/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.scm633.model.ServiceCandidateUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="ServiceCandidate is an entity that makes a service specification available to a catalog. A ServiceCandidate and its associated service specification may be published - made visible - in any number of service catalogs, or in none. One service specification can be composed of other service specifications. Skipped properties: id,href")
@Validated
public class ServiceCandidateCreate
extends ServiceCandidateUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    @Schema(description="Date and time of the last update of this REST resource")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCandidateCreate serviceCandidateCreate = (ServiceCandidateCreate)o;
        return Objects.equals(this.description, serviceCandidateCreate.description) && Objects.equals(this.lastUpdate, serviceCandidateCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceCandidateCreate.lifecycleStatus) && Objects.equals(this.name, serviceCandidateCreate.name) && Objects.equals(this.version, serviceCandidateCreate.version) && Objects.equals(this.category, serviceCandidateCreate.category) && Objects.equals(this.serviceSpecification, serviceCandidateCreate.serviceSpecification) && Objects.equals(this.validFor, serviceCandidateCreate.validFor) && Objects.equals(this.baseType, serviceCandidateCreate.baseType) && Objects.equals(this.schemaLocation, serviceCandidateCreate.schemaLocation) && Objects.equals(this.type, serviceCandidateCreate.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.lastUpdate, this.lifecycleStatus, this.name, this.version, this.category, this.serviceSpecification, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCandidateCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.serviceSpecification)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

