/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.scm633.model.ServiceCategory;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryRef;
import org.etsi.osl.tmf.scm633.model.ServiceSpecification;
import org.springframework.validation.annotation.Validated;

@Schema(description="ServiceCandidate is an entity that makes a service specification available to a catalog. A ServiceCandidate and its associated service specification may be published - made visible - in any number of service catalogs, or in none. One service specification can be composed of other service specifications.")
@Validated
@Entity(name="ServiceCandidate")
@Table(name="ServiceCandidate")
public class ServiceCandidate
extends BaseEntity {
    @ManyToMany(mappedBy="serviceCandidateObj", cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JsonIgnore
    private Set<ServiceCategory> categoryObj = new HashSet<ServiceCategory>();
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(name="service_specid", referencedColumnName="uuid")
    @JsonIgnore
    private ServiceSpecification serviceSpecificationObj = null;
    @JsonProperty(value="id")
    protected String id = null;

    public String getId() {
        if (this.uuid != null) {
            return this.uuid;
        }
        return this.id;
    }

    public ServiceCandidate() {
        this.type = "ServiceCandidate";
        this.baseType = "BaseEntity";
    }

    @Override
    public String getVersion() {
        if (this.serviceSpecificationObj != null) {
            return this.serviceSpecificationObj.getVersion();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.serviceSpecificationObj != null) {
            return this.serviceSpecificationObj.getName();
        }
        return null;
    }

    @Schema(description="The service specification implied by this candidate")
    @Transient
    @JsonProperty(value="serviceSpecification")
    @Valid
    public ServiceSpecificationRef getServiceSpecificationRef() {
        if (this.serviceSpecificationObj != null) {
            ServiceSpecificationRef sref = new ServiceSpecificationRef();
            sref.setId(this.serviceSpecificationObj.getUuid());
            sref.setName(this.serviceSpecificationObj.getName());
            sref.setVersion(this.serviceSpecificationObj.getVersion());
            sref.setBaseType(ServiceSpecificationRef.class.getName());
            return sref;
        }
        return null;
    }

    public ServiceSpecification getServiceSpecificationObj() {
        return this.serviceSpecificationObj;
    }

    @JsonProperty(value="serviceSpecification")
    public void setServiceSpecificationObj(ServiceSpecification serviceSpecificationObj) {
        this.serviceSpecificationObj = serviceSpecificationObj;
    }

    @Schema(description="The category specification implied by this candidate")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<ServiceCategoryRef> getCategory() {
        ArrayList<ServiceCategoryRef> category = new ArrayList<ServiceCategoryRef>();
        for (ServiceCategory serviceCategory : this.categoryObj) {
            ServiceCategoryRef scr = new ServiceCategoryRef();
            scr.setId(serviceCategory.getId());
            scr.setName(serviceCategory.getName());
            scr.setBaseType(ServiceCategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCandidate serviceCandidate = (ServiceCandidate)o;
        return Objects.equals(this.id, serviceCandidate.id) && Objects.equals(this.href, serviceCandidate.href) && Objects.equals(this.description, serviceCandidate.description) && Objects.equals(this.lastUpdate, serviceCandidate.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceCandidate.lifecycleStatus) && Objects.equals(this.name, serviceCandidate.name) && Objects.equals(this.version, serviceCandidate.version) && Objects.equals(this.getCategory(), serviceCandidate.getCategory()) && Objects.equals(this.getServiceSpecificationRef(), serviceCandidate.getServiceSpecificationRef()) && Objects.equals(this.validFor, serviceCandidate.validFor) && Objects.equals(this.baseType, serviceCandidate.baseType) && Objects.equals(this.schemaLocation, serviceCandidate.schemaLocation) && Objects.equals(this.type, serviceCandidate.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCandidate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategory())).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.getServiceSpecificationRef())).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Set<ServiceCategory> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<ServiceCategory> categoryObj) {
        this.categoryObj = categoryObj;
    }
}

