/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sac640.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.sac640.model.HeaderItem;
import org.springframework.validation.annotation.Validated;

@Schema(description="A response to a request")
@Validated
public class Response {
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="statusCode")
    private String statusCode = null;
    @JsonProperty(value="header")
    @Valid
    private List<HeaderItem> header = new ArrayList<HeaderItem>();
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public Response body(String body) {
        this.body = body;
        return this;
    }

    @Schema(description="The body of the response. For example for an HTTP response might contain HTML for rendering.")
    @NotNull
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Response statusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Schema(description="The status of the response. For example for an HTTP response would be codes such as 200, 400, etc.")
    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public Response header(List<HeaderItem> header) {
        this.header = header;
        return this;
    }

    public Response addHeaderItem(HeaderItem headerItem) {
        this.header.add(headerItem);
        return this;
    }

    @Schema(description="Items included in the header of the response. For example for an HTTP response might contain negotiated locale.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<HeaderItem> getHeader() {
        return this.header;
    }

    public void setHeader(List<HeaderItem> header) {
        this.header = header;
    }

    public Response baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public Response schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Response type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.body, response.body) && Objects.equals(this.statusCode, response.statusCode) && Objects.equals(this.header, response.header) && Objects.equals(this.baseType, response.baseType) && Objects.equals(this.schemaLocation, response.schemaLocation) && Objects.equals(this.type, response.type);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.statusCode, this.header, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Response {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

