/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sac640.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.sac640.model.HeaderItem;
import org.springframework.validation.annotation.Validated;

@Schema(description="A response to a request")
@Validated
public class Request {
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="method")
    private String method = null;
    @JsonProperty(value="to")
    private String to = null;
    @JsonProperty(value="header")
    @Valid
    private List<HeaderItem> header = new ArrayList<HeaderItem>();
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public Request body(String body) {
        this.body = body;
        return this;
    }

    @Schema(description="The body of the request. For example for an HTTP request might contain content of a form .")
    @NotNull
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Request method(String method) {
        this.method = method;
        return this;
    }

    @Schema(description="The protocol of the request, e.g. http")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Request to(String to) {
        this.to = to;
        return this;
    }

    @Schema(description="The target of the request, e.g. a URL for an HTTP request")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Request header(List<HeaderItem> header) {
        this.header = header;
        return this;
    }

    public Request addHeaderItem(HeaderItem headerItem) {
        this.header.add(headerItem);
        return this;
    }

    @Schema(description="Items included in the header of the request. For example for an HTTP request might contain requested locale, basic authentication.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<HeaderItem> getHeader() {
        return this.header;
    }

    public void setHeader(List<HeaderItem> header) {
        this.header = header;
    }

    public Request baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public Request schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Request type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.body, request.body) && Objects.equals(this.method, request.method) && Objects.equals(this.to, request.to) && Objects.equals(this.header, request.header) && Objects.equals(this.baseType, request.baseType) && Objects.equals(this.schemaLocation, request.schemaLocation) && Objects.equals(this.type, request.type);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.method, this.to, this.header, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Request {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

