/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sac640.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.sac640.model.Request;
import org.etsi.osl.tmf.sac640.model.Response;
import org.springframework.validation.annotation.Validated;

@Schema(description="Monitoring of resources")
@Validated
public class Monitor {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="sourceHref")
    private String sourceHref = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="request")
    private Request request = null;
    @JsonProperty(value="response")
    private Response response = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public Monitor id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of an instance of the monitor. Required to be unique within the resource type.  Used in URIs as the identifier for specific instances of a type")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Monitor href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="reference to this monitor")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Monitor sourceHref(String sourceHref) {
        this.sourceHref = sourceHref;
        return this;
    }

    @Schema(description="The monitored resource href")
    public String getSourceHref() {
        return this.sourceHref;
    }

    public void setSourceHref(String sourceHref) {
        this.sourceHref = sourceHref;
    }

    public Monitor state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The Monitor state of the resource.  InProgress, InError, Completed")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Monitor request(Request request) {
        this.request = request;
        return this;
    }

    @Schema(description="")
    @Valid
    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Monitor response(Response response) {
        this.response = response;
        return this;
    }

    @Schema(description="")
    @Valid
    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Monitor baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public Monitor schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Monitor type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Monitor monitor = (Monitor)o;
        return Objects.equals(this.id, monitor.id) && Objects.equals(this.href, monitor.href) && Objects.equals(this.sourceHref, monitor.sourceHref) && Objects.equals(this.state, monitor.state) && Objects.equals(this.request, monitor.request) && Objects.equals(this.response, monitor.response) && Objects.equals(this.baseType, monitor.baseType) && Objects.equals(this.schemaLocation, monitor.schemaLocation) && Objects.equals(this.type, monitor.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.sourceHref, this.state, this.request, this.response, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Monitor {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    sourceHref: ").append(this.toIndentedString(this.sourceHref)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

