/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="manages resource capacity with the resource state")
@Validated
@Entity(name="ResourcePoolRef")
@JsonIgnoreProperties(value={"uuid"})
public class ResourcePoolRef
extends BaseRootEntity {
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="resources")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceRef> resources = new HashSet<ResourceRef>();

    public ResourcePoolRef _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="A string. Indicates the type of the referred object. This attribute is to be used when the object is representing a reference to an existing object instead of the of the object itself.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    public ResourcePoolRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="A string. Identifier of an instance of the Resource Pool.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourcePoolRef resources(Set<ResourceRef> resourceCollection) {
        this.resources = resourceCollection;
        return this;
    }

    public ResourcePoolRef addResourcesItem(ResourceRef resourceCollectionItem) {
        if (this.resources == null) {
            this.resources = new HashSet<ResourceRef>();
        }
        this.resources.add(resourceCollectionItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ResourceRef> getResources() {
        return this.resources;
    }

    public void setResources(Set<ResourceRef> resourceCollection) {
        this.resources = resourceCollection;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePoolRef resourcePoolRef = (ResourcePoolRef)o;
        return Objects.equals(this._atReferredType, resourcePoolRef._atReferredType) && Objects.equals(this.href, resourcePoolRef.href) && Objects.equals(this.id, resourcePoolRef.id) && Objects.equals(this.resources, resourcePoolRef.resources);
    }

    public int hashCode() {
        return Objects.hash(this._atReferredType, this.href, this.id, this.resources);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourcePoolRef {\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    resourceCollection: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

