/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.rpm685.model.Capacity;
import org.springframework.validation.annotation.Validated;

@Schema(description="manages resource capacity with the resource state")
@Validated
@Entity(name="ResourcePool")
public class ResourcePool
extends BaseEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="capacity")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="resr_capacuuid", referencedColumnName="uuid")
    private Capacity capacity = null;

    @Schema(description="Unique identifier of this REST resource")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public ResourcePool setCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePool resourcePool = (ResourcePool)o;
        return Objects.equals(this.description, resourcePool.description) && Objects.equals(this.href, resourcePool.href);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseType, this.schemaLocation, this.type, this.description, this.href, this.id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourcePool {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

