/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.pcm620.model.PlaceRef;
import org.etsi.osl.tmf.rpm685.model.ApplicableTimePeriod;
import org.etsi.osl.tmf.rpm685.model.ResourcePoolRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="the amount of capacity that is planned to be consumed or has been consumed.")
@Validated
@Entity(name="ResCapacityDemand")
public class ResourceCapacityDemand
extends BaseRootEntity {
    @JsonProperty(value="capacityDemandAmount")
    private Integer capacityDemandAmount = null;
    @JsonProperty(value="resourcePool")
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="rescapcitydem_resPooluuid", referencedColumnName="uuid")
    private ResourcePoolRef resourcePool = null;
    @JsonProperty(value="applicableTimePeriod")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="rescapcitydem_applTimePerduuid", referencedColumnName="uuid")
    private ApplicableTimePeriod applicableTimePeriod = null;
    @JsonProperty(value="place")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="rescapcitydem_placeuuid", referencedColumnName="uuid")
    private PlaceRef place = null;
    @JsonProperty(value="resources")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceRef> resources = new HashSet<ResourceRef>();

    public Set<ResourceRef> getResources() {
        return this.resources;
    }

    public void setResources(Set<ResourceRef> resources) {
        this.resources = resources;
    }

    public ResourceCapacityDemand capacityDemandAmount(Integer capacityDemandAmount) {
        this.capacityDemandAmount = capacityDemandAmount;
        return this;
    }

    @Schema(description="A value and units that define the CapacityDemand, such as 10000 ea, 10B Mb.  Instance values are mutually exclusive with From and To capacityDemandAmounts and range interval.")
    public Integer getCapacityDemandAmount() {
        return this.capacityDemandAmount;
    }

    public void setCapacityDemandAmount(Integer capacityDemandAmount) {
        this.capacityDemandAmount = capacityDemandAmount;
    }

    public ResourceCapacityDemand resourcePool(ResourcePoolRef resourcePool) {
        this.resourcePool = resourcePool;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourcePoolRef getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(ResourcePoolRef resourcePool) {
        this.resourcePool = resourcePool;
    }

    public ResourceCapacityDemand applicableTimePeriod(ApplicableTimePeriod applicableTimePeriod) {
        this.applicableTimePeriod = applicableTimePeriod;
        return this;
    }

    @Schema(description="")
    @Valid
    public ApplicableTimePeriod getApplicableTimePeriod() {
        return this.applicableTimePeriod;
    }

    public void setApplicableTimePeriod(ApplicableTimePeriod applicableTimePeriod) {
        this.applicableTimePeriod = applicableTimePeriod;
    }

    public ResourceCapacityDemand place(PlaceRef place) {
        this.place = place;
        return this;
    }

    @Schema(description="")
    @Valid
    public PlaceRef getPlace() {
        return this.place;
    }

    public void setPlace(PlaceRef place) {
        this.place = place;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCapacityDemand resourceCapacityDemand = (ResourceCapacityDemand)o;
        return Objects.equals(this.getBaseType(), resourceCapacityDemand.getBaseType()) && Objects.equals(this.getSchemaLocation(), resourceCapacityDemand.getSchemaLocation()) && Objects.equals(this.getType(), resourceCapacityDemand.getType()) && Objects.equals(this.capacityDemandAmount, resourceCapacityDemand.capacityDemandAmount) && Objects.equals(this.applicableTimePeriod, resourceCapacityDemand.applicableTimePeriod) && Objects.equals(this.place, resourceCapacityDemand.place);
    }

    public int hashCode() {
        return Objects.hash(this.getBaseType(), this.getSchemaLocation(), this.getType(), this.capacityDemandAmount, this.applicableTimePeriod, this.place);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCapacityDemand {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.getBaseType())).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.getSchemaLocation())).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.getType())).append("\n");
        sb.append("    capacityDemandAmount: ").append(this.toIndentedString(this.capacityDemandAmount)).append("\n");
        sb.append("    applicableTimePeriod: ").append(this.toIndentedString(this.applicableTimePeriod)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

