/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rpm685.model.ReservationItem;
import org.etsi.osl.tmf.sim638.model.ServiceOrderRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="reservation api resource Skipped properties: id,href")
@Validated
public class ReservationUpdate {
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="relatedParty")
    private RelatedParty relatedParty = null;
    @JsonProperty(value="reservationState")
    private String reservationState = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="reservationItem")
    @Valid
    private List<ReservationItem> reservationItem = null;
    private OffsetDateTime requestedPeriodEndDateTime = null;
    private OffsetDateTime requestedPeriodStartDateTime = null;
    @JsonProperty(value="serviceOrderRef")
    private ServiceOrderRef serviceOrderRef = null;

    public ServiceOrderRef getServiceOrderRef() {
        return this.serviceOrderRef;
    }

    public void setServiceOrderRef(ServiceOrderRef serviceOrderRef) {
        this.serviceOrderRef = serviceOrderRef;
    }

    public ReservationUpdate serviceOrderRef(ServiceOrderRef serviceOrderRef) {
        this.serviceOrderRef = serviceOrderRef;
        return this;
    }

    @JsonProperty(value="requestedPeriodEndDateTime")
    public String getRequestedPeriodEndDateTimeStr() {
        if (this.requestedPeriodEndDateTime != null) {
            return this.requestedPeriodEndDateTime.toString();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OffsetDateTime getRequestedPeriodEndDateTime() {
        return this.requestedPeriodEndDateTime;
    }

    public void setRequestedPeriodEndDateTime(OffsetDateTime requestedPeriodEndDateTime) {
        this.requestedPeriodEndDateTime = requestedPeriodEndDateTime;
    }

    public ReservationUpdate requestedPeriodEndDateTime(OffsetDateTime requestedPeriodEndDateTime) {
        this.requestedPeriodEndDateTime = requestedPeriodEndDateTime;
        return this;
    }

    public void setRequestedPeriodEndDateTime(String requestedPeriodEndDateTime) {
        if (requestedPeriodEndDateTime != null) {
            this.requestedPeriodEndDateTime = OffsetDateTime.parse(requestedPeriodEndDateTime);
        }
    }

    public OffsetDateTime getRequestedPeriodStartDateTime() {
        return this.requestedPeriodStartDateTime;
    }

    public void setRequestedPeriodStartDateTime(OffsetDateTime requestedPeriodStartDateTime) {
        this.requestedPeriodStartDateTime = requestedPeriodStartDateTime;
    }

    public ReservationUpdate requestedPeriodStartDateTime(OffsetDateTime requestedPeriodStartDateTime) {
        this.requestedPeriodStartDateTime = requestedPeriodStartDateTime;
        return this;
    }

    @JsonProperty(value="requestedPeriodStartDateTime")
    public String getRequestedPeriodStartDateTimeStr() {
        if (this.requestedPeriodStartDateTime != null) {
            return this.requestedPeriodStartDateTime.toString();
        }
        return null;
    }

    public void setRequestedPeriodStartDateTime(String requestedPeriodStartDateTime) {
        if (requestedPeriodStartDateTime != null) {
            this.requestedPeriodStartDateTime = OffsetDateTime.parse(requestedPeriodStartDateTime);
        }
    }

    public ReservationUpdate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ReservationUpdate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A string. Generic attribute containing the link to the schema that defines the structure of the class type of the current object.")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ReservationUpdate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="A string. Indicates the (class) type of reservation. Ex. serviceItemReservation, resourceItemReservation")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public ReservationUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A string. free-text description of the reservation.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReservationUpdate relatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    @Schema(description="")
    @Valid
    public RelatedParty getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ReservationUpdate reservationState(String reservationState) {
        this.reservationState = reservationState;
        return this;
    }

    @Schema(description="A string. The life cycle state of the reservation.")
    public String getReservationState() {
        return this.reservationState;
    }

    public void setReservationState(String reservationState) {
        this.reservationState = reservationState;
    }

    public ReservationUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time for which the reservation is applicable.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ReservationUpdate reservationItem(List<ReservationItem> reservationItem) {
        this.reservationItem = reservationItem;
        return this;
    }

    public ReservationUpdate addReservationItemItem(ReservationItem reservationItemItem) {
        if (this.reservationItem == null) {
            this.reservationItem = new ArrayList<ReservationItem>();
        }
        this.reservationItem.add(reservationItemItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ReservationItem> getReservationItem() {
        return this.reservationItem;
    }

    public void setReservationItem(List<ReservationItem> reservationItem) {
        this.reservationItem = reservationItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservationUpdate reservationUpdate = (ReservationUpdate)o;
        return Objects.equals(this._atBaseType, reservationUpdate._atBaseType) && Objects.equals(this._atSchemaLocation, reservationUpdate._atSchemaLocation) && Objects.equals(this._atType, reservationUpdate._atType) && Objects.equals(this.description, reservationUpdate.description) && Objects.equals(this.relatedParty, reservationUpdate.relatedParty) && Objects.equals(this.reservationState, reservationUpdate.reservationState) && Objects.equals(this.validFor, reservationUpdate.validFor) && Objects.equals(this.reservationItem, reservationUpdate.reservationItem);
    }

    public int hashCode() {
        return Objects.hash(this._atBaseType, this._atSchemaLocation, this._atType, this.description, this.relatedParty, this.reservationState, this.validFor, this.reservationItem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReservationUpdate {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    reservationState: ").append(this.toIndentedString(this.reservationState)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    reservationItem: ").append(this.toIndentedString(this.reservationItem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

