/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.rpm685.model.AppliedCapacityAmount;
import org.etsi.osl.tmf.rpm685.model.ResourceCapacityDemand;
import org.springframework.validation.annotation.Validated;

@Schema(description="An identified part of the reservation. A reservation is decomposed into one or more reservation items.")
@Validated
@Entity(name="ReservationItem")
public class ReservationItem
extends BaseRootEntity {
    @JsonProperty(value="quantity")
    private Integer quantity = null;
    @JsonProperty(value="subReservationState")
    private String subReservationState = null;
    @JsonProperty(value="resourceCapacity")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="reservitem_resrcapuuid", referencedColumnName="uuid")
    private ResourceCapacityDemand resourceCapacity = null;
    @JsonProperty(value="appliedCapacityAmount")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="reservitem_appliedcapuuid", referencedColumnName="uuid")
    private AppliedCapacityAmount appliedCapacityAmount = null;

    public ReservationItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="Represents the number of reservationItems that make up the reservation.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ReservationItem subReservationState(String subReservationState) {
        this.subReservationState = subReservationState;
        return this;
    }

    @Schema(description="A string. The life cycle state of the each reservation item.")
    public String getSubReservationState() {
        return this.subReservationState;
    }

    public void setSubReservationState(String subReservationState) {
        this.subReservationState = subReservationState;
    }

    public ReservationItem resourceCapacity(ResourceCapacityDemand resourceCapacity) {
        this.resourceCapacity = resourceCapacity;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceCapacityDemand getResourceCapacity() {
        return this.resourceCapacity;
    }

    public void setResourceCapacity(ResourceCapacityDemand resourceCapacity) {
        this.resourceCapacity = resourceCapacity;
    }

    public ReservationItem appliedCapacityAmount(AppliedCapacityAmount appliedCapacityAmount) {
        this.appliedCapacityAmount = appliedCapacityAmount;
        return this;
    }

    @Schema(description="")
    @Valid
    public AppliedCapacityAmount getAppliedCapacityAmount() {
        return this.appliedCapacityAmount;
    }

    public void setAppliedCapacityAmount(AppliedCapacityAmount appliedCapacityAmount) {
        this.appliedCapacityAmount = appliedCapacityAmount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservationItem reservationItem = (ReservationItem)o;
        return Objects.equals(this.getBaseType(), reservationItem.getBaseType()) && Objects.equals(this.getSchemaLocation(), reservationItem.getSchemaLocation()) && Objects.equals(this.getType(), reservationItem.getType()) && Objects.equals(this.quantity, reservationItem.quantity) && Objects.equals(this.subReservationState, reservationItem.subReservationState) && Objects.equals(this.resourceCapacity, reservationItem.resourceCapacity) && Objects.equals(this.appliedCapacityAmount, reservationItem.appliedCapacityAmount);
    }

    public int hashCode() {
        return Objects.hash(this.getBaseType(), this.getSchemaLocation(), this.getType(), this.quantity, this.subReservationState, this.resourceCapacity, this.appliedCapacityAmount);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReservationItem {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.getBaseType())).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.getSchemaLocation())).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.getType())).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    subReservationState: ").append(this.toIndentedString(this.subReservationState)).append("\n");
        sb.append("    resourceCapacity: ").append(this.toIndentedString(this.resourceCapacity)).append("\n");
        sb.append("    appliedCapacityAmount: ").append(this.toIndentedString(this.appliedCapacityAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

