/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rpm685.model.ReservationItem;
import org.etsi.osl.tmf.sim638.model.ServiceOrderRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="reservation api resource")
@Validated
@Entity(name="Reservation")
public class Reservation
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relatedParty")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="reserv_relParuuid", referencedColumnName="uuid")
    private RelatedParty relatedParty = null;
    @JsonProperty(value="reservationState")
    private String reservationState = null;
    @JsonProperty(value="reservationItem")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ReservationItem> reservationItem = new HashSet<ReservationItem>();
    @Column(name="reqPeriodStartDate")
    private OffsetDateTime requestedPeriodStartDateTime = null;
    @Column(name="reqPeriodEndDate")
    private OffsetDateTime requestedPeriodEndDateTime = null;
    @JsonProperty(value="serviceOrderRef")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="Reserv_soRefuuid", referencedColumnName="uuid")
    private ServiceOrderRef serviceOrderRef = null;

    @Schema(description="A string. Identifier of an instance of the Reservation.")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ServiceOrderRef getServiceOrderRef() {
        return this.serviceOrderRef;
    }

    public void setServiceOrderRef(ServiceOrderRef serviceOrderRef) {
        this.serviceOrderRef = serviceOrderRef;
    }

    public Reservation serviceOrderRef(ServiceOrderRef serviceOrderRef) {
        this.serviceOrderRef = serviceOrderRef;
        return this;
    }

    @Schema(description="End of the time period, using IETC-RFC-3339 format")
    @Valid
    @JsonProperty(value="requestedPeriodEndDateTime")
    public String getRequestedPeriodEndDateTimeString() {
        if (this.requestedPeriodEndDateTime != null) {
            return this.requestedPeriodEndDateTime.toString();
        }
        return null;
    }

    public OffsetDateTime getRequestedPeriodEndDateTime() {
        return this.requestedPeriodEndDateTime;
    }

    public void setRequestedPeriodEndDateTime(OffsetDateTime endDateTime) {
        this.requestedPeriodEndDateTime = endDateTime;
    }

    public Reservation requestedPeriodStartDateTime(OffsetDateTime startDateTime) {
        this.requestedPeriodStartDateTime = startDateTime;
        return this;
    }

    public void setRequestedPeriodEndDateTime(String endDateTime) {
        this.requestedPeriodEndDateTime = OffsetDateTime.parse(endDateTime);
    }

    @Schema(description="Start of the time period, using IETC-RFC-3339 format. If you define a start, you must also define an end")
    @Valid
    @JsonProperty(value="requestedPeriodStartDateTime")
    public String getRequestedPeriodStartDateTimeString() {
        if (this.requestedPeriodStartDateTime != null) {
            return this.requestedPeriodStartDateTime.toString();
        }
        return null;
    }

    public OffsetDateTime getRequestedPeriodStartDateTime() {
        return this.requestedPeriodStartDateTime;
    }

    public void setRequestedPeriodStartDateTime(OffsetDateTime startDateTime) {
        this.requestedPeriodStartDateTime = startDateTime;
    }

    public void setRequestedPeriodStartDateTime(String startDateTime) {
        if (startDateTime != null) {
            this.requestedPeriodStartDateTime = OffsetDateTime.parse(startDateTime);
        }
    }

    public Reservation relatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    @Schema(description="")
    @Valid
    public RelatedParty getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Reservation reservationState(String reservationState) {
        this.reservationState = reservationState;
        return this;
    }

    @Schema(description="A string. The life cycle state of the reservation.")
    public String getReservationState() {
        return this.reservationState;
    }

    public void setReservationState(String reservationState) {
        this.reservationState = reservationState;
    }

    public Reservation reservationItem(Set<ReservationItem> reservationItem) {
        this.reservationItem = reservationItem;
        return this;
    }

    public Reservation addReservationItemItem(ReservationItem reservationItemItem) {
        if (this.reservationItem == null) {
            this.reservationItem = new HashSet<ReservationItem>();
        }
        this.reservationItem.add(reservationItemItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ReservationItem> getReservationItem() {
        return this.reservationItem;
    }

    public void setReservationItem(Set<ReservationItem> reservationItem) {
        this.reservationItem = reservationItem;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reservation reservation = (Reservation)o;
        return Objects.equals(this.getBaseType(), reservation.getBaseType()) && Objects.equals(this.getSchemaLocation(), reservation.getSchemaLocation()) && Objects.equals(this.getType(), reservation.getType()) && Objects.equals(this.description, reservation.description) && Objects.equals(this.href, reservation.href) && Objects.equals(this.id, reservation.id) && Objects.equals(this.relatedParty, reservation.relatedParty) && Objects.equals(this.reservationState, reservation.reservationState) && Objects.equals(this.validFor, reservation.validFor) && Objects.equals(this.reservationItem, reservation.reservationItem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getBaseType(), this.getSchemaLocation(), this.getType(), this.description, this.href, this.id, this.relatedParty, this.reservationState, this.validFor, this.reservationItem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reservation {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.getBaseType())).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.getSchemaLocation())).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.getType())).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    reservationState: ").append(this.toIndentedString(this.reservationState)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    reservationItem: ").append(this.toIndentedString(this.reservationItem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

