/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="The period of time for which user requested to use the resources. The user can request on the start date without the end date.")
@Validated
public class RequestedPeriod {
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;
    @JsonProperty(value="daysOfWeek")
    private String daysOfWeek = null;
    @JsonProperty(value="fromToDateTime")
    private OffsetDateTime fromToDateTime = null;
    @JsonProperty(value="rangeInterval")
    private String rangeInterval = null;
    @JsonProperty(value="validFor")
    private String validFor = null;

    public RequestedPeriod _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="A string. Generic attribute indicating the base class type of the extension class of the current object. Useful only when the class type of the current  object is unknown to the implementation.")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public RequestedPeriod _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A string. Generic attribute containing the link to the schema that defines the structure of the class type of the current object.")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public RequestedPeriod _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="A string. Generic attribute containing the name of the resource class type.")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public RequestedPeriod daysOfWeek(String daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Schema(description="A day or days representing when the schedule is applicable. For example 2, 3 represent Monday and Tuesday.")
    public String getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(String daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public RequestedPeriod fromToDateTime(OffsetDateTime fromToDateTime) {
        this.fromToDateTime = fromToDateTime;
        return this;
    }

    @Schema(description="The period of time for which the schedule is applicable.  Instance values are mutually exclusive with daysOfWeek values.")
    @Valid
    public OffsetDateTime getFromToDateTime() {
        return this.fromToDateTime;
    }

    public void setFromToDateTime(OffsetDateTime fromToDateTime) {
        this.fromToDateTime = fromToDateTime;
    }

    public RequestedPeriod rangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
        return this;
    }

    @Schema(description="An indicator that specifies the inclusion or exclusion of the from and to DateTime attributes.  Possible values are \"open\", \"closed\", \"closedBottom\" and \"closedTop\".")
    public String getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
    }

    public RequestedPeriod validFor(String validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time during which the schedule is considered of interest to the business.")
    public String getValidFor() {
        return this.validFor;
    }

    public void setValidFor(String validFor) {
        this.validFor = validFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestedPeriod requestedPeriod = (RequestedPeriod)o;
        return Objects.equals(this._atBaseType, requestedPeriod._atBaseType) && Objects.equals(this._atSchemaLocation, requestedPeriod._atSchemaLocation) && Objects.equals(this._atType, requestedPeriod._atType) && Objects.equals(this.daysOfWeek, requestedPeriod.daysOfWeek) && Objects.equals(this.fromToDateTime, requestedPeriod.fromToDateTime) && Objects.equals(this.rangeInterval, requestedPeriod.rangeInterval) && Objects.equals(this.validFor, requestedPeriod.validFor);
    }

    public int hashCode() {
        return Objects.hash(this._atBaseType, this._atSchemaLocation, this._atType, this.daysOfWeek, this.fromToDateTime, this.rangeInterval, this.validFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestedPeriod {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    fromToDateTime: ").append(this.toIndentedString(this.fromToDateTime)).append("\n");
        sb.append("    rangeInterval: ").append(this.toIndentedString(this.rangeInterval)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

