/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.etsi.osl.tmf.rpm685.model.Capacity;
import org.etsi.osl.tmf.rpm685.model.ResourcePoolRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="the extract task resource for resource pool management")
@Validated
public class Extract {
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="@type")
    private String _atType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="capacity")
    private Capacity capacity = null;
    @JsonProperty(value="resourcePool")
    private ResourcePoolRef resourcePool = null;

    public Capacity getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Capacity capacity) {
        this.capacity = capacity;
    }

    public ResourcePoolRef getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(ResourcePoolRef resourcePool) {
        this.resourcePool = resourcePool;
    }

    public Extract href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="A string. Hyperlink to access the availableCheck task for resource pool Management")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Extract id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="A string. Identifier of an instance of the extract task for resource pool Management")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Extract _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public Extract _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public Extract _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extract extract = (Extract)o;
        return Objects.equals(this.href, extract.href) && Objects.equals(this.id, extract.id) && Objects.equals(this._atType, extract._atType) && Objects.equals(this._atSchemaLocation, extract._atSchemaLocation) && Objects.equals(this._atBaseType, extract._atBaseType);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this._atType, this._atSchemaLocation, this._atBaseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Extract {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

