/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
public class Error {
    @JsonProperty(value="code")
    private Integer code = null;
    @JsonProperty(value="reason")
    private Integer reason = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="status")
    private Integer status = null;
    @JsonProperty(value="referenceError")
    private String referenceError = null;
    @JsonProperty(value="@type")
    private String _atType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;

    public Error code(Integer code) {
        this.code = code;
        return this;
    }

    @Schema(description="Application related code.")
    @NotNull
    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Error reason(Integer reason) {
        this.reason = reason;
        return this;
    }

    @Schema(description="Text that explains the reason for error.")
    @NotNull
    public Integer getReason() {
        return this.reason;
    }

    public void setReason(Integer reason) {
        this.reason = reason;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Schema(description="(optional) Text that provide more details and corrective actions related to the error.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error status(Integer status) {
        this.status = status;
        return this;
    }

    @Schema(description="(optional) http error code extension like 400-2")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Error referenceError(String referenceError) {
        this.referenceError = referenceError;
        return this;
    }

    @Schema(description="(optional) A URL to online documentation that provides more information about the error.")
    public String getReferenceError() {
        return this.referenceError;
    }

    public void setReferenceError(String referenceError) {
        this.referenceError = referenceError;
    }

    public Error _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="(optional) The class type of a REST resource.")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public Error _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="(optional) A link to the schema describing a REST resource.")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.code, error.code) && Objects.equals(this.reason, error.reason) && Objects.equals(this.message, error.message) && Objects.equals(this.status, error.status) && Objects.equals(this.referenceError, error.referenceError) && Objects.equals(this._atType, error._atType) && Objects.equals(this._atSchemaLocation, error._atSchemaLocation);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.reason, this.message, this.status, this.referenceError, this._atType, this._atSchemaLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    referenceError: ").append(this.toIndentedString(this.referenceError)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

