/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.HashSet;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.pcm620.model.PlaceRef;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rpm685.model.AppliedCapacityAmount;

@Entity(name="Capacity")
public class Capacity
extends BaseRootEntity {
    @JsonProperty(value="capacityAmount")
    private Integer capacityAmount;
    @JsonProperty(value="relatedParty")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="capacity_relParuuid", referencedColumnName="uuid")
    private RelatedParty relatedParty;
    @JsonProperty(value="place")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="capacity_placeuuid", referencedColumnName="uuid")
    private PlaceRef place;
    @JsonProperty(value="resources")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceRef> resources = new HashSet<ResourceRef>();
    @JsonProperty(value="appliedCapacityAmount")
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AppliedCapacityAmount> appliedCapacityAmount = new HashSet<AppliedCapacityAmount>();

    public Capacity addResourceRefItem(ResourceRef aResourceRef) {
        this.resources.add(aResourceRef);
        return this;
    }

    public Capacity addAppliedCapacityAmountItem(AppliedCapacityAmount anAppliedCapacityAmount) {
        this.appliedCapacityAmount.add(anAppliedCapacityAmount);
        return this;
    }

    public Integer getCapacityAmount() {
        return this.capacityAmount;
    }

    public RelatedParty getRelatedParty() {
        return this.relatedParty;
    }

    public PlaceRef getPlace() {
        return this.place;
    }

    public Set<ResourceRef> getResources() {
        return this.resources;
    }

    public Set<AppliedCapacityAmount> getAppliedCapacityAmount() {
        return this.appliedCapacityAmount;
    }

    @JsonProperty(value="capacityAmount")
    public void setCapacityAmount(Integer capacityAmount) {
        this.capacityAmount = capacityAmount;
    }

    @JsonProperty(value="relatedParty")
    public void setRelatedParty(RelatedParty relatedParty) {
        this.relatedParty = relatedParty;
    }

    @JsonProperty(value="place")
    public void setPlace(PlaceRef place) {
        this.place = place;
    }

    @JsonProperty(value="resources")
    public void setResources(Set<ResourceRef> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="appliedCapacityAmount")
    public void setAppliedCapacityAmount(Set<AppliedCapacityAmount> appliedCapacityAmount) {
        this.appliedCapacityAmount = appliedCapacityAmount;
    }

    @Override
    public String toString() {
        return "Capacity(capacityAmount=" + this.getCapacityAmount() + ", relatedParty=" + String.valueOf(this.getRelatedParty()) + ", place=" + String.valueOf(this.getPlace()) + ", resources=" + String.valueOf(this.getResources()) + ", appliedCapacityAmount=" + String.valueOf(this.getAppliedCapacityAmount()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$capacityAmount = this.getCapacityAmount();
        Integer other$capacityAmount = other.getCapacityAmount();
        if (this$capacityAmount == null ? other$capacityAmount != null : !((Object)this$capacityAmount).equals(other$capacityAmount)) {
            return false;
        }
        RelatedParty this$relatedParty = this.getRelatedParty();
        RelatedParty other$relatedParty = other.getRelatedParty();
        if (this$relatedParty == null ? other$relatedParty != null : !((Object)this$relatedParty).equals(other$relatedParty)) {
            return false;
        }
        PlaceRef this$place = this.getPlace();
        PlaceRef other$place = other.getPlace();
        if (this$place == null ? other$place != null : !((Object)this$place).equals(other$place)) {
            return false;
        }
        Set<ResourceRef> this$resources = this.getResources();
        Set<ResourceRef> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Set<AppliedCapacityAmount> this$appliedCapacityAmount = this.getAppliedCapacityAmount();
        Set<AppliedCapacityAmount> other$appliedCapacityAmount = other.getAppliedCapacityAmount();
        return !(this$appliedCapacityAmount == null ? other$appliedCapacityAmount != null : !((Object)this$appliedCapacityAmount).equals(other$appliedCapacityAmount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Capacity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $capacityAmount = this.getCapacityAmount();
        result = result * 59 + ($capacityAmount == null ? 43 : ((Object)$capacityAmount).hashCode());
        RelatedParty $relatedParty = this.getRelatedParty();
        result = result * 59 + ($relatedParty == null ? 43 : ((Object)$relatedParty).hashCode());
        PlaceRef $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : ((Object)$place).hashCode());
        Set<ResourceRef> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Set<AppliedCapacityAmount> $appliedCapacityAmount = this.getAppliedCapacityAmount();
        result = result * 59 + ($appliedCapacityAmount == null ? 43 : ((Object)$appliedCapacityAmount).hashCode());
        return result;
    }
}

