/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.rpm685.model.ResourceCapacityDemand;
import org.springframework.validation.annotation.Validated;

@Schema(description="The amount of CapcityDemand applied to a CapacityAmount.")
@Validated
@Entity(name="ApplCapacityAmnt")
public class AppliedCapacityAmount
extends BaseRootEntity {
    @JsonProperty(value="appliedDemandAmount")
    private Integer appliedDemandAmount = null;
    @JsonProperty(value="resourceCapacityDemand")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="appcapcityamount_resCapctDemnduuid", referencedColumnName="uuid")
    private ResourceCapacityDemand resourceCapacityDemand = null;
    @JsonProperty(value="resources")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceRef> resources = new HashSet<ResourceRef>();

    public AppliedCapacityAmount appliedDemandAmount(Integer appliedDemandAmount) {
        this.appliedDemandAmount = appliedDemandAmount;
        return this;
    }

    @Schema(description="An amount of demand applied to a CapacityAmount. Note that this is a composite attribute defined by CapacityAmount.")
    public Integer getAppliedDemandAmount() {
        return this.appliedDemandAmount;
    }

    public void setAppliedDemandAmount(Integer appliedDemandAmount) {
        this.appliedDemandAmount = appliedDemandAmount;
    }

    public AppliedCapacityAmount resourceCapacityDemand(ResourceCapacityDemand resourceCapacityDemand) {
        this.resourceCapacityDemand = resourceCapacityDemand;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceCapacityDemand getResourceCapacityDemand() {
        return this.resourceCapacityDemand;
    }

    public void setResourceCapacityDemand(ResourceCapacityDemand resourceCapacityDemand) {
        this.resourceCapacityDemand = resourceCapacityDemand;
    }

    public AppliedCapacityAmount resource(Set<ResourceRef> resource) {
        this.resources = resource;
        return this;
    }

    public AppliedCapacityAmount addResourceItem(ResourceRef resourceItem) {
        this.resources.add(resourceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ResourceRef> getResource() {
        return this.resources;
    }

    public void setResource(Set<ResourceRef> resource) {
        this.resources = resource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppliedCapacityAmount appliedCapacityAmount = (AppliedCapacityAmount)o;
        return Objects.equals(this.baseType, appliedCapacityAmount.baseType) && Objects.equals(this.getSchemaLocation(), appliedCapacityAmount.getSchemaLocation()) && Objects.equals(this.getType(), appliedCapacityAmount.getType()) && Objects.equals(this.appliedDemandAmount, appliedCapacityAmount.appliedDemandAmount) && Objects.equals(this.resourceCapacityDemand, appliedCapacityAmount.resourceCapacityDemand) && Objects.equals(this.resources, appliedCapacityAmount.resources);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppliedCapacityAmount {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.getSchemaLocation())).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.getType())).append("\n");
        sb.append("    appliedDemandAmount: ").append(this.toIndentedString(this.appliedDemandAmount)).append("\n");
        sb.append("    resourceCapacityDemand: ").append(this.toIndentedString(this.resourceCapacityDemand)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

