/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rpm685.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="The period of time for which Capacity or CapacityDemand applies.")
@Validated
@Entity(name="ApplcbleTPer")
public class ApplicableTimePeriod
extends BaseRootEntity {
    @JsonProperty(value="dayOfWeek")
    private String dayOfWeek = null;
    private OffsetDateTime fromDateTime = null;
    private OffsetDateTime endDateTime = null;
    @JsonProperty(value="rangeInterval")
    private String rangeInterval = null;

    public ApplicableTimePeriod dayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @Schema(description="A day or days representing when the schedule is applicable. For example 2, 3 represent Monday and Tuesday.")
    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public ApplicableTimePeriod fromDateTime(OffsetDateTime fromDateTime) {
        this.fromDateTime = fromDateTime;
        return this;
    }

    @JsonProperty(value="fromDateTime")
    public String getfromDateTimeString() {
        if (this.fromDateTime == null) {
            return null;
        }
        return this.fromDateTime.toString();
    }

    @Schema(description="The period of time for which the schedule is applicable.  Instance values are mutually exclusive with daysOfWeek values.")
    @Valid
    public OffsetDateTime getFromDateTime() {
        return this.fromDateTime;
    }

    public void setFromDateTime(OffsetDateTime fromDateTime) {
        this.fromDateTime = fromDateTime;
    }

    public void setFromDateTime(String fromDateTime) {
        this.fromDateTime = OffsetDateTime.parse(fromDateTime);
    }

    public ApplicableTimePeriod endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @JsonProperty(value="endDateTime")
    public String getendDateTimeString() {
        if (this.endDateTime == null) {
            return null;
        }
        return this.endDateTime.toString();
    }

    @Schema(description="The period of time for which the schedule is applicable.  Instance values are mutually exclusive with daysOfWeek values.")
    @Valid
    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public void setEndDateTime(String endDateTime) {
        this.endDateTime = OffsetDateTime.parse(endDateTime);
    }

    public ApplicableTimePeriod rangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
        return this;
    }

    @Schema(description="An indicator that specifies the inclusion or exclusion of the from and to DateTime attributes.  Possible values are \"open\", \"closed\", \"closedBottom\" and \"closedTop\".")
    public String getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicableTimePeriod applicableTimePeriod = (ApplicableTimePeriod)o;
        return Objects.equals(this.getBaseType(), applicableTimePeriod.getBaseType()) && Objects.equals(this.getSchemaLocation(), applicableTimePeriod.getSchemaLocation()) && Objects.equals(this.getType(), applicableTimePeriod.getType()) && Objects.equals(this.dayOfWeek, applicableTimePeriod.dayOfWeek) && Objects.equals(this.fromDateTime, applicableTimePeriod.fromDateTime) && Objects.equals(this.rangeInterval, applicableTimePeriod.rangeInterval);
    }

    public int hashCode() {
        return Objects.hash(this.getBaseType(), this.getSchemaLocation(), this.getType(), this.dayOfWeek, this.fromDateTime, this.rangeInterval);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicableTimePeriod {\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.getBaseType())).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.getSchemaLocation())).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.getType())).append("\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString(this.dayOfWeek)).append("\n");
        sb.append("    fromToDateTime: ").append(this.toIndentedString(this.fromDateTime)).append("\n");
        sb.append("    rangeInterval: ").append(this.toIndentedString(this.rangeInterval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

