/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.ro652.model.ExternalId;
import org.etsi.osl.tmf.ro652.model.ResourceOrderItem;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Resource Order is a request to provision a set of Resources (logical and physical) triggered by the request to provision a Service through a Service Order Skipped properties: id,href,completionDate,orderDate")
@Validated
public class ResourceOrderUpdate {
    @JsonProperty(value="category")
    private String category = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="expectedCompletionDate")
    private OffsetDateTime expectedCompletionDate = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="orderType")
    private String orderType = null;
    @JsonProperty(value="priority")
    private Integer priority = null;
    @JsonProperty(value="requestedCompletionDate")
    private OffsetDateTime requestedCompletionDate = null;
    @JsonProperty(value="requestedStartDate")
    private OffsetDateTime requestedStartDate = null;
    @JsonProperty(value="startDate")
    private OffsetDateTime startDate = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="externalReference")
    @Valid
    private List<ExternalId> externalReference = null;
    @JsonProperty(value="note")
    @Valid
    private List<Note> note = null;
    @JsonProperty(value="orderItem")
    @Valid
    private List<ResourceOrderItem> orderItem = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ResourceOrderUpdate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order from a business perspective that can be useful for the OM system.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceOrderUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="free-text description of the Resource Order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceOrderUpdate expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(description="Date when the order was completed")
    @Valid
    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public ResourceOrderUpdate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="DEPRECATED: Use externalReference Instead. ID given by the consumer (to facilitate searches afterwards)")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ResourceOrderUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A string used to give a name to the Resource Order")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceOrderUpdate orderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    @Schema(description="Name of the Resource Order type")
    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public ResourceOrderUpdate priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A way that can be used by consumers to prioritize orders in OM system (from 0 to 4 : 0 is the highest priority, and 4 the lowest)")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ResourceOrderUpdate requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestor perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public ResourceOrderUpdate requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    @Schema(description="Order start date wished by the requestor")
    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public ResourceOrderUpdate startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the order was actually started")
    @Valid
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public ResourceOrderUpdate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The life cycle state of the resource.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ResourceOrderUpdate externalReference(List<ExternalId> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public ResourceOrderUpdate addExternalReferenceItem(ExternalId externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new ArrayList<ExternalId>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ExternalId> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(List<ExternalId> externalReference) {
        this.externalReference = externalReference;
    }

    public ResourceOrderUpdate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ResourceOrderUpdate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ResourceOrderUpdate orderItem(List<ResourceOrderItem> orderItem) {
        this.orderItem = orderItem;
        return this;
    }

    public ResourceOrderUpdate addOrderItemItem(ResourceOrderItem orderItemItem) {
        if (this.orderItem == null) {
            this.orderItem = new ArrayList<ResourceOrderItem>();
        }
        this.orderItem.add(orderItemItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceOrderItem> getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(List<ResourceOrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public ResourceOrderUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceOrderUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceOrderUpdate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceOrderUpdate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceOrderUpdate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceOrderUpdate resourceOrderUpdate = (ResourceOrderUpdate)o;
        return Objects.equals(this.category, resourceOrderUpdate.category) && Objects.equals(this.description, resourceOrderUpdate.description) && Objects.equals(this.expectedCompletionDate, resourceOrderUpdate.expectedCompletionDate) && Objects.equals(this.externalId, resourceOrderUpdate.externalId) && Objects.equals(this.name, resourceOrderUpdate.name) && Objects.equals(this.orderType, resourceOrderUpdate.orderType) && Objects.equals(this.priority, resourceOrderUpdate.priority) && Objects.equals(this.requestedCompletionDate, resourceOrderUpdate.requestedCompletionDate) && Objects.equals(this.requestedStartDate, resourceOrderUpdate.requestedStartDate) && Objects.equals(this.startDate, resourceOrderUpdate.startDate) && Objects.equals(this.state, resourceOrderUpdate.state) && Objects.equals(this.externalReference, resourceOrderUpdate.externalReference) && Objects.equals(this.note, resourceOrderUpdate.note) && Objects.equals(this.orderItem, resourceOrderUpdate.orderItem) && Objects.equals(this.relatedParty, resourceOrderUpdate.relatedParty) && Objects.equals(this._atBaseType, resourceOrderUpdate._atBaseType) && Objects.equals(this._atSchemaLocation, resourceOrderUpdate._atSchemaLocation) && Objects.equals(this._atType, resourceOrderUpdate._atType);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.description, this.expectedCompletionDate, this.externalId, this.name, this.orderType, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.startDate, this.state, this.externalReference, this.note, this.orderItem, this.relatedParty, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceOrderUpdate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString(this.orderType)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderItem: ").append(this.toIndentedString(this.orderItem)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

