/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.ResourceRefOrValue;
import org.etsi.osl.tmf.ro652.model.AppointmentRef;
import org.etsi.osl.tmf.ro652.model.ResourceOrderItemRelationship;
import org.etsi.osl.tmf.ro652.model.ResourceOrderStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="An identified part of the order. A resource order is decomposed into one or more order items.")
@Validated
public class ResourceOrderItem {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="quantity")
    private Integer quantity = null;
    @JsonProperty(value="state")
    private ResourceOrderStateType state = null;
    @JsonProperty(value="appointment")
    private AppointmentRef appointment = null;
    @JsonProperty(value="orderItemRelationship")
    @Valid
    private List<ResourceOrderItemRelationship> orderItemRelationship = null;
    @JsonProperty(value="resource")
    private ResourceRefOrValue resource = null;
    @JsonProperty(value="resourceSpecification")
    private ResourceSpecificationRef resourceSpecification = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ResourceOrderItem id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the line item (generally it is a sequence number 01, 02, 03, ...)")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceOrderItem action(String action) {
        this.action = action;
        return this;
    }

    @Schema(description="Can be \"add\" / \"modify\" / \"no_change\"/ \"delete\"")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public ResourceOrderItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="Quantity ordered")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ResourceOrderItem state(ResourceOrderStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="State of the order item : described in the state machine diagram")
    public ResourceOrderStateType getState() {
        return this.state;
    }

    public void setState(ResourceOrderStateType state) {
        this.state = state;
    }

    public ResourceOrderItem appointment(AppointmentRef appointment) {
        this.appointment = appointment;
        return this;
    }

    @Schema(description="")
    @Valid
    public AppointmentRef getAppointment() {
        return this.appointment;
    }

    public void setAppointment(AppointmentRef appointment) {
        this.appointment = appointment;
    }

    public ResourceOrderItem orderItemRelationship(List<ResourceOrderItemRelationship> orderItemRelationship) {
        this.orderItemRelationship = orderItemRelationship;
        return this;
    }

    public ResourceOrderItem addOrderItemRelationshipItem(ResourceOrderItemRelationship orderItemRelationshipItem) {
        if (this.orderItemRelationship == null) {
            this.orderItemRelationship = new ArrayList<ResourceOrderItemRelationship>();
        }
        this.orderItemRelationship.add(orderItemRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceOrderItemRelationship> getOrderItemRelationship() {
        return this.orderItemRelationship;
    }

    public void setOrderItemRelationship(List<ResourceOrderItemRelationship> orderItemRelationship) {
        this.orderItemRelationship = orderItemRelationship;
    }

    public ResourceOrderItem resource(ResourceRefOrValue resource) {
        this.resource = resource;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceRefOrValue getResource() {
        return this.resource;
    }

    public void setResourceRefOrValue(ResourceRefOrValue resource) {
        this.resource = resource;
    }

    public ResourceOrderItem resourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceSpecificationRef getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ResourceOrderItem _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceOrderItem _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceOrderItem _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceOrderItem resourceOrderItem = (ResourceOrderItem)o;
        return Objects.equals(this.id, resourceOrderItem.id) && Objects.equals(this.action, resourceOrderItem.action) && Objects.equals(this.quantity, resourceOrderItem.quantity) && Objects.equals((Object)this.state, (Object)resourceOrderItem.state) && Objects.equals(this.appointment, resourceOrderItem.appointment) && Objects.equals(this.orderItemRelationship, resourceOrderItem.orderItemRelationship) && Objects.equals(this.resource, resourceOrderItem.resource) && Objects.equals(this.resourceSpecification, resourceOrderItem.resourceSpecification) && Objects.equals(this._atBaseType, resourceOrderItem._atBaseType) && Objects.equals(this._atSchemaLocation, resourceOrderItem._atSchemaLocation) && Objects.equals(this._atType, resourceOrderItem._atType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.action, this.quantity, this.state, this.appointment, this.orderItemRelationship, this.resource, this.resourceSpecification, this._atBaseType, this._atSchemaLocation, this._atType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceOrderItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    appointment: ").append(this.toIndentedString(this.appointment)).append("\n");
        sb.append("    orderItemRelationship: ").append(this.toIndentedString(this.orderItemRelationship)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

