/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.ro652.model.ExternalId;
import org.etsi.osl.tmf.ro652.model.ResourceOrderItem;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Resource Order is a request to provision a set of Resources (logical and physical) triggered by the request to provision a Service through a Service Order Skipped properties: id,href")
@Validated
public class ResourceOrderCreate {
    @JsonProperty(value="category")
    private String category = null;
    @JsonProperty(value="completionDate")
    private OffsetDateTime completionDate = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="expectedCompletionDate")
    private OffsetDateTime expectedCompletionDate = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="orderDate")
    private OffsetDateTime orderDate = null;
    @JsonProperty(value="orderType")
    private String orderType = null;
    @JsonProperty(value="priority")
    private Integer priority = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    @JsonProperty(value="startDate")
    private OffsetDateTime startDate = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="externalReference")
    @Valid
    private List<ExternalId> externalReference = null;
    @JsonProperty(value="note")
    @Valid
    private List<Note> note = null;
    @JsonProperty(value="orderItem")
    @Valid
    private List<ResourceOrderItem> orderItem = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ResourceOrderCreate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order from a business perspective that can be useful for the OM system.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceOrderCreate completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Date when the order was completed")
    @Valid
    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public ResourceOrderCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="free-text description of the Resource Order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceOrderCreate expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(description="Date when the order was completed")
    @Valid
    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public ResourceOrderCreate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="DEPRECATED: Use externalReference Instead. ID given by the consumer (to facilitate searches afterwards)")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ResourceOrderCreate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A string used to give a name to the Resource Order")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceOrderCreate orderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(description="Date when the order was created")
    @Valid
    public OffsetDateTime getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public ResourceOrderCreate orderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    @Schema(description="Name of the Resource Order type")
    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public ResourceOrderCreate priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A way that can be used by consumers to prioritize orders in OM system (from 0 to 4 : 0 is the highest priority, and 4 the lowest)")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ResourceOrderCreate requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    public ResourceOrderCreate requestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
        return this;
    }

    @Schema(description="Requested delivery date from the requestor perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateStr() {
        if (this.requestedCompletionDate != null) {
            return this.requestedCompletionDate.toString();
        }
        return null;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    public ResourceOrderCreate requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    public ResourceOrderCreate requestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
        return this;
    }

    @Schema(description="Order start date wished by the requestor")
    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateStr() {
        if (this.requestedStartDate != null) {
            return this.requestedStartDate.toString();
        }
        return null;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ResourceOrderCreate startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the order was actually started")
    @Valid
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public ResourceOrderCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The life cycle state of the resource.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ResourceOrderCreate externalReference(List<ExternalId> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public ResourceOrderCreate addExternalReferenceItem(ExternalId externalReferenceItem) {
        if (this.externalReference == null) {
            this.externalReference = new ArrayList<ExternalId>();
        }
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ExternalId> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(List<ExternalId> externalReference) {
        this.externalReference = externalReference;
    }

    public ResourceOrderCreate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ResourceOrderCreate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ResourceOrderCreate orderItem(List<ResourceOrderItem> orderItem) {
        this.orderItem = orderItem;
        return this;
    }

    public ResourceOrderCreate addOrderItemItem(ResourceOrderItem orderItemItem) {
        if (this.orderItem == null) {
            this.orderItem = new ArrayList<ResourceOrderItem>();
        }
        this.orderItem.add(orderItemItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceOrderItem> getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(List<ResourceOrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public ResourceOrderCreate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceOrderCreate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceOrderCreate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceOrderCreate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceOrderCreate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceOrderCreate resourceOrderCreate = (ResourceOrderCreate)o;
        return Objects.equals(this.category, resourceOrderCreate.category) && Objects.equals(this.completionDate, resourceOrderCreate.completionDate) && Objects.equals(this.description, resourceOrderCreate.description) && Objects.equals(this.expectedCompletionDate, resourceOrderCreate.expectedCompletionDate) && Objects.equals(this.externalId, resourceOrderCreate.externalId) && Objects.equals(this.name, resourceOrderCreate.name) && Objects.equals(this.orderDate, resourceOrderCreate.orderDate) && Objects.equals(this.orderType, resourceOrderCreate.orderType) && Objects.equals(this.priority, resourceOrderCreate.priority) && Objects.equals(this.requestedCompletionDate, resourceOrderCreate.requestedCompletionDate) && Objects.equals(this.requestedStartDate, resourceOrderCreate.requestedStartDate) && Objects.equals(this.startDate, resourceOrderCreate.startDate) && Objects.equals(this.state, resourceOrderCreate.state) && Objects.equals(this.externalReference, resourceOrderCreate.externalReference) && Objects.equals(this.note, resourceOrderCreate.note) && Objects.equals(this.orderItem, resourceOrderCreate.orderItem) && Objects.equals(this.relatedParty, resourceOrderCreate.relatedParty) && Objects.equals(this._atBaseType, resourceOrderCreate._atBaseType) && Objects.equals(this._atSchemaLocation, resourceOrderCreate._atSchemaLocation) && Objects.equals(this._atType, resourceOrderCreate._atType);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.completionDate, this.description, this.expectedCompletionDate, this.externalId, this.name, this.orderDate, this.orderType, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.startDate, this.state, this.externalReference, this.note, this.orderItem, this.relatedParty, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceOrderCreate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString(this.orderType)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderItem: ").append(this.toIndentedString(this.orderItem)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

