/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.ro652.model.ExternalId;
import org.etsi.osl.tmf.ro652.model.ResourceOrderItem;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Resource Order is a request to provision a set of Resources (logical and physical) triggered by the request to provision a Service through a Service Order")
@Validated
public class ResourceOrder {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="category")
    private String category = null;
    private OffsetDateTime completionDate = null;
    private OffsetDateTime expectedCompletionDate = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    private OffsetDateTime startDate = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="name")
    private String name = null;
    private OffsetDateTime orderDate = null;
    @JsonProperty(value="orderType")
    private String orderType = null;
    @JsonProperty(value="priority")
    private Integer priority = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="externalReference")
    @Valid
    private Set<ExternalId> externalReference = new HashSet<ExternalId>();
    @JsonProperty(value="note")
    @Valid
    private Set<Note> note = new HashSet<Note>();
    @JsonProperty(value="orderItem")
    @Valid
    private Set<ResourceOrderItem> orderItem = new HashSet<ResourceOrderItem>();
    @JsonProperty(value="relatedParty")
    @Valid
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ResourceOrder id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of an instance of the Resource Order. Required to be unique within the resource type.  Used in URIs as the identifier for specific instances of a type.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceOrder href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Hyperlink to access the order")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ResourceOrder category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order from a business perspective that can be useful for the OM system.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceOrder completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Effective delivery date amended by the provider")
    @Valid
    @JsonProperty(value="completionDate")
    public String getCompletionDateString() {
        if (this.completionDate == null) {
            return null;
        }
        return this.completionDate.toString();
    }

    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setCompletionDate(String completionDate) {
        if (completionDate != null) {
            this.completionDate = OffsetDateTime.parse(completionDate);
        }
    }

    public ResourceOrder description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="free-text description of the Resource Order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceOrder expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(description="Expected delivery date amended by the provider")
    @Valid
    @JsonProperty(value="expectedCompletionDate")
    public String getExpectedCompletionDateString() {
        if (this.expectedCompletionDate == null) {
            return null;
        }
        return this.expectedCompletionDate.toString();
    }

    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void setExpectedCompletionDate(String expectedCompletionDate) {
        if (expectedCompletionDate != null) {
            this.expectedCompletionDate = OffsetDateTime.parse(expectedCompletionDate);
        }
    }

    public ResourceOrder externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="DEPRECATED: Use externalReference Instead. ID given by the consumer (to facilitate searches afterwards)")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ResourceOrder name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A string used to give a name to the Resource Order")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceOrder orderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(description="")
    @Valid
    @JsonProperty(value="orderDate")
    public String getOrderDateString() {
        if (this.orderDate == null) {
            return null;
        }
        return this.orderDate.toString();
    }

    public OffsetDateTime getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public void setOrderDate(String orderDate) {
        if (orderDate != null) {
            this.orderDate = OffsetDateTime.parse(orderDate);
        }
    }

    public ResourceOrder orderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    @Schema(description="Name of the Resource Order type")
    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public ResourceOrder priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="A way that can be used by consumers to prioritize orders in OM system (from 0 to 4 : 0 is the highest priority, and 4 the lowest)")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ResourceOrder requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestor perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    @Schema(description="Requested delivery date from the requestors perspective")
    @Valid
    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateString() {
        if (this.requestedCompletionDate == null) {
            return null;
        }
        return this.requestedCompletionDate.toString();
    }

    @Schema(description="Order start date wished by the requestor")
    @Valid
    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateString() {
        if (this.requestedStartDate == null) {
            return null;
        }
        return this.requestedStartDate.toString();
    }

    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public ResourceOrder requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ResourceOrder startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the order was started for processing")
    @Valid
    @JsonProperty(value="startDate")
    public String getStartDateString() {
        if (this.startDate == null) {
            return null;
        }
        return this.startDate.toString();
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.startDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ResourceOrder state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The life cycle state of the resource.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ResourceOrder externalReference(Set<ExternalId> externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public ResourceOrder addExternalReferenceItem(ExternalId externalReferenceItem) {
        this.externalReference.add(externalReferenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ExternalId> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(Set<ExternalId> externalReference) {
        this.externalReference = externalReference;
    }

    public ResourceOrder note(Set<Note> note) {
        this.note = note;
        return this;
    }

    public ResourceOrder addNoteItem(Note noteItem) {
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Note> getNote() {
        return this.note;
    }

    public void setNote(Set<Note> note) {
        this.note = note;
    }

    public ResourceOrder orderItem(Set<ResourceOrderItem> orderItem) {
        this.orderItem = orderItem;
        return this;
    }

    public ResourceOrder addOrderItemItem(ResourceOrderItem orderItemItem) {
        this.orderItem.add(orderItemItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ResourceOrderItem> getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(Set<ResourceOrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public ResourceOrder relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceOrder addRelatedPartyItem(RelatedParty relatedPartyItem) {
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceOrder _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceOrder _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceOrder _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceOrder resourceOrder = (ResourceOrder)o;
        return Objects.equals(this.id, resourceOrder.id) && Objects.equals(this.href, resourceOrder.href) && Objects.equals(this.category, resourceOrder.category) && Objects.equals(this.completionDate, resourceOrder.completionDate) && Objects.equals(this.description, resourceOrder.description) && Objects.equals(this.expectedCompletionDate, resourceOrder.expectedCompletionDate) && Objects.equals(this.externalId, resourceOrder.externalId) && Objects.equals(this.name, resourceOrder.name) && Objects.equals(this.orderDate, resourceOrder.orderDate) && Objects.equals(this.orderType, resourceOrder.orderType) && Objects.equals(this.priority, resourceOrder.priority) && Objects.equals(this.requestedCompletionDate, resourceOrder.requestedCompletionDate) && Objects.equals(this.requestedStartDate, resourceOrder.requestedStartDate) && Objects.equals(this.startDate, resourceOrder.startDate) && Objects.equals(this.state, resourceOrder.state) && Objects.equals(this.externalReference, resourceOrder.externalReference) && Objects.equals(this.note, resourceOrder.note) && Objects.equals(this.orderItem, resourceOrder.orderItem) && Objects.equals(this.relatedParty, resourceOrder.relatedParty) && Objects.equals(this._atBaseType, resourceOrder._atBaseType) && Objects.equals(this._atSchemaLocation, resourceOrder._atSchemaLocation) && Objects.equals(this._atType, resourceOrder._atType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.category, this.completionDate, this.description, this.expectedCompletionDate, this.externalId, this.name, this.orderDate, this.orderType, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.startDate, this.state, this.externalReference, this.note, this.orderItem, this.relatedParty, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceOrder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString(this.orderType)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    externalReference: ").append(this.toIndentedString(this.externalReference)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderItem: ").append(this.toIndentedString(this.orderItem)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

