/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="Related Entity reference. A related place defines a place described by reference or by value linked to a specific entity. The polymorphic attributes @type, @schemaLocation & @referredType are related to the place entity and not the RelatedPlaceRefOrValue class itself")
@Validated
public class RelatedPlaceRefOrValue {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public RelatedPlaceRefOrValue id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the place")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RelatedPlaceRefOrValue href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Unique reference of the place")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public RelatedPlaceRefOrValue name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A user-friendly name for the place, such as [Paris Store], [London Store], [Main Home]")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RelatedPlaceRefOrValue role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="")
    @NotNull
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedPlaceRefOrValue _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public RelatedPlaceRefOrValue _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public RelatedPlaceRefOrValue _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public RelatedPlaceRefOrValue _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedPlaceRefOrValue relatedPlaceRefOrValue = (RelatedPlaceRefOrValue)o;
        return Objects.equals(this.id, relatedPlaceRefOrValue.id) && Objects.equals(this.href, relatedPlaceRefOrValue.href) && Objects.equals(this.name, relatedPlaceRefOrValue.name) && Objects.equals(this.role, relatedPlaceRefOrValue.role) && Objects.equals(this._atBaseType, relatedPlaceRefOrValue._atBaseType) && Objects.equals(this._atSchemaLocation, relatedPlaceRefOrValue._atSchemaLocation) && Objects.equals(this._atType, relatedPlaceRefOrValue._atType) && Objects.equals(this._atReferredType, relatedPlaceRefOrValue._atReferredType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.role, this._atBaseType, this._atSchemaLocation, this._atType, this._atReferredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedPlaceRefOrValue {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

