/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="An identification of an entity that is owned by or originates in a software system different from the current system, for example a ProductOrder handed off from a commerce platform into an order handling system. The structure identifies the system itself, the nature of the entity within the system (e.g. class name) and the unique ID of the entity within the system. It is anticipated that multiple external IDs can be held for a single entity, e.g. if the entity passed through multiple systems on the way to the current system. In this case the consumer is expected to sequence the IDs in the array in reverse order of provenance, i.e. most recent system first in the list.")
@Validated
public class ExternalId {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="entityType")
    private String entityType = null;
    @JsonProperty(value="owner")
    private String owner = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ExternalId id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="ID of the entity within the external system.")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExternalId entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @Schema(description="Type of the entity within the external system")
    @NotNull
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public ExternalId owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Schema(description="Name of the external system that owns the entity.")
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExternalId _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ExternalId _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ExternalId _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalId externalId = (ExternalId)o;
        return Objects.equals(this.id, externalId.id) && Objects.equals(this.entityType, externalId.entityType) && Objects.equals(this.owner, externalId.owner) && Objects.equals(this._atBaseType, externalId._atBaseType) && Objects.equals(this._atSchemaLocation, externalId._atSchemaLocation) && Objects.equals(this._atType, externalId._atType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.entityType, this.owner, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalId {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

