/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.ro652.model.ResourceOrderRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Request for cancellation an existing resource order Skipped properties: id,href,state,effectiveCancellationDate")
@Validated
public class CancelResourceOrderCreate {
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="requestedCancellationDate")
    private OffsetDateTime requestedCancellationDate = null;
    @JsonProperty(value="resourceOrder")
    private ResourceOrderRef resourceOrder = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public CancelResourceOrderCreate cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled.")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public CancelResourceOrderCreate requestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
        return this;
    }

    @Schema(description="Date when the submitter wants the order to be cancelled")
    @Valid
    public OffsetDateTime getRequestedCancellationDate() {
        return this.requestedCancellationDate;
    }

    public void setRequestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
    }

    public CancelResourceOrderCreate resourceOrder(ResourceOrderRef resourceOrder) {
        this.resourceOrder = resourceOrder;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ResourceOrderRef getResourceOrder() {
        return this.resourceOrder;
    }

    public void setResourceOrder(ResourceOrderRef resourceOrder) {
        this.resourceOrder = resourceOrder;
    }

    public CancelResourceOrderCreate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public CancelResourceOrderCreate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public CancelResourceOrderCreate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelResourceOrderCreate cancelResourceOrderCreate = (CancelResourceOrderCreate)o;
        return Objects.equals(this.cancellationReason, cancelResourceOrderCreate.cancellationReason) && Objects.equals(this.requestedCancellationDate, cancelResourceOrderCreate.requestedCancellationDate) && Objects.equals(this.resourceOrder, cancelResourceOrderCreate.resourceOrder) && Objects.equals(this._atBaseType, cancelResourceOrderCreate._atBaseType) && Objects.equals(this._atSchemaLocation, cancelResourceOrderCreate._atSchemaLocation) && Objects.equals(this._atType, cancelResourceOrderCreate._atType);
    }

    public int hashCode() {
        return Objects.hash(this.cancellationReason, this.requestedCancellationDate, this.resourceOrder, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelResourceOrderCreate {\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    requestedCancellationDate: ").append(this.toIndentedString(this.requestedCancellationDate)).append("\n");
        sb.append("    resourceOrder: ").append(this.toIndentedString(this.resourceOrder)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

