/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ro652.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.ro652.model.TaskStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Order cancel is a type of task which  can  be used to place a request to cancel an order")
@Validated
public class CancelOrder {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="cancellationReason")
    private String cancellationReason = null;
    @JsonProperty(value="effectiveCancellationDate")
    private OffsetDateTime effectiveCancellationDate = null;
    @JsonProperty(value="requestedCancellationDate")
    private OffsetDateTime requestedCancellationDate = null;
    @JsonProperty(value="state")
    private TaskStateType state = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public CancelOrder id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="id of the cancellation request (this is not an order id)")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CancelOrder href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Hyperlink to access the cancellation request")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public CancelOrder cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Schema(description="Reason why the order is cancelled.")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public CancelOrder effectiveCancellationDate(OffsetDateTime effectiveCancellationDate) {
        this.effectiveCancellationDate = effectiveCancellationDate;
        return this;
    }

    @Schema(description="Date when the order is cancelled.")
    @Valid
    public OffsetDateTime getEffectiveCancellationDate() {
        return this.effectiveCancellationDate;
    }

    public void setEffectiveCancellationDate(OffsetDateTime effectiveCancellationDate) {
        this.effectiveCancellationDate = effectiveCancellationDate;
    }

    public CancelOrder requestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
        return this;
    }

    @Schema(description="Date when the submitter wants the order to be cancelled")
    @Valid
    public OffsetDateTime getRequestedCancellationDate() {
        return this.requestedCancellationDate;
    }

    public void setRequestedCancellationDate(OffsetDateTime requestedCancellationDate) {
        this.requestedCancellationDate = requestedCancellationDate;
    }

    public CancelOrder state(TaskStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="")
    @Valid
    public TaskStateType getState() {
        return this.state;
    }

    public void setState(TaskStateType state) {
        this.state = state;
    }

    public CancelOrder _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public CancelOrder _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public CancelOrder _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelOrder cancelOrder = (CancelOrder)o;
        return Objects.equals(this.id, cancelOrder.id) && Objects.equals(this.href, cancelOrder.href) && Objects.equals(this.cancellationReason, cancelOrder.cancellationReason) && Objects.equals(this.effectiveCancellationDate, cancelOrder.effectiveCancellationDate) && Objects.equals(this.requestedCancellationDate, cancelOrder.requestedCancellationDate) && Objects.equals((Object)this.state, (Object)cancelOrder.state) && Objects.equals(this._atBaseType, cancelOrder._atBaseType) && Objects.equals(this._atSchemaLocation, cancelOrder._atSchemaLocation) && Objects.equals(this._atType, cancelOrder._atType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.cancellationReason, this.effectiveCancellationDate, this.requestedCancellationDate, this.state, this._atBaseType, this._atSchemaLocation, this._atType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelOrder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    effectiveCancellationDate: ").append(this.toIndentedString(this.effectiveCancellationDate)).append("\n");
        sb.append("    requestedCancellationDate: ").append(this.toIndentedString(this.requestedCancellationDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

