/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.Characteristic;
import org.etsi.osl.tmf.ri639.model.Feature;
import org.etsi.osl.tmf.ri639.model.RelatedPlaceRefOrValue;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceRelationship;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resource is an abstract entity that describes the common set of attributes shared by all concrete resources (e.g. TPE, EQUIPMENT) in the inventory. Skipped properties: id,href")
@Validated
public class ResourceUpdate {
    @JsonProperty(value="category")
    protected String category = null;
    @JsonProperty(value="description")
    protected String description = null;
    protected OffsetDateTime endOperatingDate = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="resourceVersion")
    protected String resourceVersion = null;
    protected OffsetDateTime startOperatingDate = null;
    @JsonProperty(value="activationFeature")
    @Valid
    protected List<Feature> activationFeature = null;
    @JsonProperty(value="administrativeState")
    protected ResourceAdministrativeStateType administrativeState = null;
    @JsonProperty(value="attachment")
    @Valid
    protected List<AttachmentRefOrValue> attachment = null;
    @JsonProperty(value="note")
    @Valid
    protected List<Note> note = null;
    @JsonProperty(value="operationalState")
    protected ResourceOperationalStateType operationalState = null;
    @JsonProperty(value="place")
    protected RelatedPlaceRefOrValue place = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="resourceCharacteristic")
    @Valid
    protected List<Characteristic> resourceCharacteristic = null;
    @JsonProperty(value="resourceRelationship")
    @Valid
    protected List<ResourceRelationship> resourceRelationship = null;
    @JsonProperty(value="resourceSpecification")
    protected ResourceSpecificationRef resourceSpecification = null;
    @JsonProperty(value="resourceStatus")
    protected ResourceStatusType resourceStatus = null;
    @JsonProperty(value="usageState")
    protected ResourceUsageStateType usageState = null;
    @JsonProperty(value="@baseType")
    protected String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    protected String _atType = null;

    public ResourceUpdate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="free-text description of the resource")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceUpdate endOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
        return this;
    }

    @Schema(description="A date time( DateTime). The date till the resource is operating")
    @Valid
    public OffsetDateTime getEndOperatingDate() {
        return this.endOperatingDate;
    }

    public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
    }

    @JsonProperty(value="endOperatingDate")
    @Valid
    public String getEndOperatingDateStr() {
        if (this.endOperatingDate != null) {
            return this.endOperatingDate.toString();
        }
        return null;
    }

    public void setEndOperatingDate(String endOperatingDate) {
        if (endOperatingDate != null) {
            this.endOperatingDate = OffsetDateTime.parse(endOperatingDate);
        }
    }

    public ResourceUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A string used to give a name to the resource")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceUpdate resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Schema(description="A field that identifies the specific version of an instance of a resource.")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public ResourceUpdate startOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
        return this;
    }

    @Schema(description="A date time( DateTime). The date from which the resource is operating")
    @Valid
    public OffsetDateTime getStartOperatingDate() {
        return this.startOperatingDate;
    }

    @JsonProperty(value="startOperatingDate")
    public String getStartOperatingDateStr() {
        if (this.startOperatingDate != null) {
            return this.startOperatingDate.toString();
        }
        return null;
    }

    public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
    }

    public void setStartOperatingDate(String startOperatingDate) {
        if (startOperatingDate != null) {
            this.startOperatingDate = OffsetDateTime.parse(startOperatingDate);
        }
    }

    public ResourceUpdate activationFeature(List<Feature> activationFeature) {
        this.activationFeature = activationFeature;
        return this;
    }

    public ResourceUpdate addActivationFeatureItem(Feature activationFeatureItem) {
        if (this.activationFeature == null) {
            this.activationFeature = new ArrayList<Feature>();
        }
        this.activationFeature.add(activationFeatureItem);
        return this;
    }

    @Schema(description="Configuration features")
    @Valid
    public List<Feature> getActivationFeature() {
        return this.activationFeature;
    }

    public void setActivationFeature(List<Feature> activationFeature) {
        this.activationFeature = activationFeature;
    }

    public ResourceUpdate administrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceAdministrativeStateType getAdministrativeState() {
        return this.administrativeState;
    }

    public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
    }

    public ResourceUpdate attachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ResourceUpdate addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ResourceUpdate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ResourceUpdate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ResourceUpdate operationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceOperationalStateType getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
    }

    public ResourceUpdate place(RelatedPlaceRefOrValue place) {
        this.place = place;
        return this;
    }

    @Schema(description="")
    @Valid
    public RelatedPlaceRefOrValue getPlace() {
        return this.place;
    }

    public void setPlace(RelatedPlaceRefOrValue place) {
        this.place = place;
    }

    public ResourceUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceUpdate resourceCharacteristic(List<Characteristic> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
        return this;
    }

    public ResourceUpdate addResourceCharacteristicItem(Characteristic resourceCharacteristicItem) {
        if (this.resourceCharacteristic == null) {
            this.resourceCharacteristic = new ArrayList<Characteristic>();
        }
        this.resourceCharacteristic.add(resourceCharacteristicItem);
        return this;
    }

    public ResourceUpdate addResourceCharacteristicItemShort(String aname, String aValue, String valueType) {
        Characteristic resCharacteristicItem = new Characteristic();
        resCharacteristicItem.setName(aname);
        Any val = new Any();
        val.setValue(aValue);
        val.setAlias(null);
        resCharacteristicItem.setValue(val);
        this.addResourceCharacteristicItem(resCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Characteristic> getResourceCharacteristic() {
        return this.resourceCharacteristic;
    }

    public void setResourceCharacteristic(List<Characteristic> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
    }

    public ResourceUpdate resourceRelationship(List<ResourceRelationship> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
        return this;
    }

    public ResourceUpdate addResourceRelationshipItem(ResourceRelationship resourceRelationshipItem) {
        if (this.resourceRelationship == null) {
            this.resourceRelationship = new ArrayList<ResourceRelationship>();
        }
        this.resourceRelationship.add(resourceRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceRelationship> getResourceRelationship() {
        return this.resourceRelationship;
    }

    public void setResourceRelationship(List<ResourceRelationship> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
    }

    public ResourceUpdate resourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceSpecificationRef getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ResourceUpdate resourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceStatusType getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public ResourceUpdate usageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceUsageStateType getUsageState() {
        return this.usageState;
    }

    public void setUsageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
    }

    public ResourceUpdate _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceUpdate _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceUpdate _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class Extensible name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUpdate resourceUpdate = (ResourceUpdate)o;
        return Objects.equals(this.category, resourceUpdate.category) && Objects.equals(this.description, resourceUpdate.description) && Objects.equals(this.endOperatingDate, resourceUpdate.endOperatingDate) && Objects.equals(this.name, resourceUpdate.name) && Objects.equals(this.resourceVersion, resourceUpdate.resourceVersion) && Objects.equals(this.startOperatingDate, resourceUpdate.startOperatingDate) && Objects.equals(this.activationFeature, resourceUpdate.activationFeature) && Objects.equals((Object)this.administrativeState, (Object)resourceUpdate.administrativeState) && Objects.equals(this.attachment, resourceUpdate.attachment) && Objects.equals(this.note, resourceUpdate.note) && Objects.equals((Object)this.operationalState, (Object)resourceUpdate.operationalState) && Objects.equals(this.place, resourceUpdate.place) && Objects.equals(this.relatedParty, resourceUpdate.relatedParty) && Objects.equals(this.resourceCharacteristic, resourceUpdate.resourceCharacteristic) && Objects.equals(this.resourceRelationship, resourceUpdate.resourceRelationship) && Objects.equals(this.resourceSpecification, resourceUpdate.resourceSpecification) && Objects.equals((Object)this.resourceStatus, (Object)resourceUpdate.resourceStatus) && Objects.equals((Object)this.usageState, (Object)resourceUpdate.usageState) && Objects.equals(this._atBaseType, resourceUpdate._atBaseType) && Objects.equals(this._atSchemaLocation, resourceUpdate._atSchemaLocation) && Objects.equals(this._atType, resourceUpdate._atType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.description, this.endOperatingDate, this.name, this.resourceVersion, this.startOperatingDate, this.activationFeature, this.administrativeState, this.attachment, this.note, this.operationalState, this.place, this.relatedParty, this.resourceCharacteristic, this.resourceRelationship, this.resourceSpecification, this.resourceStatus, this.usageState, this._atBaseType, this._atSchemaLocation, this._atType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceUpdate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    protected String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

