/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Linked resources to the one instantiate, such as [bundled] if the resource is a bundle and you want to describe the bundled resources inside this bundle; [reliesOn] if the resource needs another already owned resource to rely on (e.g. an option on an already owned mobile access resource) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful")
@Validated
@Entity(name="RIResourceRel")
public class ResourceRelationship
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="resource")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="rsrc_rsrcref_uuid", referencedColumnName="uuid")
    private ResourceRef resource = null;

    @Schema(description="unique identifier")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ResourceRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(example="bundled", required=true, description="Type of the resource relationship, such as [bundled] if the resource is a bundle and you want to describe the bundled resources inside this bundle; [reliesOn] if the resource needs another already owned resource to rely on (eg: an option on an already owned mobile access resource) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ResourceRelationship resource(ResourceRef resource) {
        this.resource = resource;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public ResourceRef getResource() {
        return this.resource;
    }

    public void setResource(ResourceRef resource) {
        this.resource = resource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRelationship resourceRelationship = (ResourceRelationship)o;
        return Objects.equals(this.id, resourceRelationship.id) && Objects.equals(this.href, resourceRelationship.href) && Objects.equals(this.relationshipType, resourceRelationship.relationshipType) && Objects.equals(this.resource, resourceRelationship.resource) && Objects.equals(this.baseType, resourceRelationship.baseType) && Objects.equals(this.schemaLocation, resourceRelationship.schemaLocation) && Objects.equals(this.type, resourceRelationship.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.relationshipType, this.resource, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

