/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.Characteristic;
import org.etsi.osl.tmf.ri639.model.Feature;
import org.etsi.osl.tmf.ri639.model.RelatedPlaceRefOrValue;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceRelationship;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resource is an abstract entity that describes the common set of attributes shared by all concrete resources (e.g. TPE, EQUIPMENT) in the inventory.")
@Validated
@Entity(name="RIResource")
public class Resource
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="category")
    protected String category = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    protected String description = null;
    protected OffsetDateTime endOperatingDate = null;
    @JsonProperty(value="resourceVersion")
    protected String resourceVersion = null;
    protected OffsetDateTime startOperatingDate = null;
    @JsonProperty(value="activationFeature")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<Feature> activationFeature = new HashSet<Feature>();
    @JsonProperty(value="administrativeState")
    protected ResourceAdministrativeStateType administrativeState = null;
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<AttachmentRefOrValue> attachment = new HashSet<AttachmentRefOrValue>();
    @JsonProperty(value="note")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<Note> note = new HashSet<Note>();
    @JsonProperty(value="operationalState")
    protected ResourceOperationalStateType operationalState = null;
    @JsonProperty(value="place")
    @OneToOne(cascade={CascadeType.ALL})
    protected RelatedPlaceRefOrValue place = null;
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="resourceCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<Characteristic> resourceCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="resourceRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ResourceRelationship> resourceRelationship = new HashSet<ResourceRelationship>();
    @JsonProperty(value="resourceSpecification")
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="resSpecRef", referencedColumnName="uuid")
    protected ResourceSpecificationRef resourceSpecification = null;
    @JsonProperty(value="resourceStatus")
    protected ResourceStatusType resourceStatus = ResourceStatusType.UNKNOWN;
    @JsonProperty(value="usageState")
    protected ResourceUsageStateType usageState = ResourceUsageStateType.IDLE;

    @Schema(description="Identifier of an instance of the resource. Required to be unique within the resource type.  Used in URIs as the identifier for specific instances of a type.")
    @NotNull
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    @Override
    @Schema(description="The URI for the object itself.")
    @NotNull
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public Resource category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Resource description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="free-text description of the resource")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="endOperatingDate")
    public String getEndOperatingDateStr() {
        if (this.endOperatingDate != null) {
            return this.endOperatingDate.toString();
        }
        return null;
    }

    public void setEndOperatingDate(String endDate) {
        if (endDate != null) {
            this.endOperatingDate = OffsetDateTime.parse(endDate);
        }
    }

    public Resource endOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
        return this;
    }

    @Schema(description="A date time( DateTime). The date till the resource is operating")
    @Valid
    public OffsetDateTime getEndOperatingDate() {
        return this.endOperatingDate;
    }

    public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
    }

    @Override
    public Resource name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A string used to give a name to the resource")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Resource resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Schema(description="A field that identifies the specific version of an instance of a resource.")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public Resource startOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
        return this;
    }

    @Schema(description="A date time( DateTime). The date from which the resource is operating")
    @JsonProperty(value="startOperatingDate")
    public String getStartOperatingDateStr() {
        if (this.startOperatingDate != null) {
            return this.startOperatingDate.toString();
        }
        return null;
    }

    public void setStartOperatingDate(String startOperatingDate) {
        if (startOperatingDate != null) {
            this.startOperatingDate = OffsetDateTime.parse(startOperatingDate);
        }
    }

    @Valid
    public OffsetDateTime getStartOperatingDate() {
        return this.startOperatingDate;
    }

    public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
    }

    public Resource activationFeature(Set<Feature> activationFeature) {
        this.activationFeature = activationFeature;
        return this;
    }

    public Resource addActivationFeatureItem(Feature activationFeatureItem) {
        if (this.activationFeature == null) {
            this.activationFeature = new HashSet<Feature>();
        }
        this.activationFeature.add(activationFeatureItem);
        return this;
    }

    @Schema(description="Configuration features")
    @Valid
    public Set<Feature> getActivationFeature() {
        return this.activationFeature;
    }

    public void setActivationFeature(Set<Feature> activationFeature) {
        this.activationFeature = activationFeature;
    }

    public Resource administrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceAdministrativeStateType getAdministrativeState() {
        return this.administrativeState;
    }

    public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
    }

    public Resource attachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public Resource addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public Resource note(Set<Note> note) {
        this.note = note;
        return this;
    }

    public Resource addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new HashSet<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Note> getNote() {
        return this.note;
    }

    public void setNote(Set<Note> note) {
        this.note = note;
    }

    public Resource operationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceOperationalStateType getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
    }

    public Resource place(RelatedPlaceRefOrValue place) {
        this.place = place;
        return this;
    }

    @Schema(description="")
    @Valid
    public RelatedPlaceRefOrValue getPlace() {
        return this.place;
    }

    public void setPlace(RelatedPlaceRefOrValue place) {
        this.place = place;
    }

    public Resource relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Resource addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Resource resourceCharacteristic(Set<Characteristic> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
        return this;
    }

    public Resource addResourceCharacteristicItem(Characteristic resourceCharacteristicItem) {
        if (this.resourceCharacteristic == null) {
            this.resourceCharacteristic = new HashSet<Characteristic>();
        }
        this.resourceCharacteristic.add(resourceCharacteristicItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Characteristic> getResourceCharacteristic() {
        return this.resourceCharacteristic;
    }

    public void setResourceCharacteristic(Set<Characteristic> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
    }

    public Resource resourceRelationship(Set<ResourceRelationship> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
        return this;
    }

    public Resource addResourceRelationshipItem(ResourceRelationship resourceRelationshipItem) {
        if (this.resourceRelationship == null) {
            this.resourceRelationship = new HashSet<ResourceRelationship>();
        }
        this.resourceRelationship.add(resourceRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ResourceRelationship> getResourceRelationship() {
        return this.resourceRelationship;
    }

    public void setResourceRelationship(Set<ResourceRelationship> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
    }

    public Resource resourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceSpecificationRef getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public Resource resourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceStatusType getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public Resource usageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceUsageStateType getUsageState() {
        return this.usageState;
    }

    public void setUsageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.id, resource.id) && Objects.equals(this.href, resource.href) && Objects.equals(this.category, resource.category) && Objects.equals(this.description, resource.description) && Objects.equals(this.endOperatingDate, resource.endOperatingDate) && Objects.equals(this.name, resource.name) && Objects.equals(this.resourceVersion, resource.resourceVersion) && Objects.equals(this.startOperatingDate, resource.startOperatingDate) && Objects.equals(this.activationFeature, resource.activationFeature) && Objects.equals((Object)this.administrativeState, (Object)resource.administrativeState) && Objects.equals(this.attachment, resource.attachment) && Objects.equals(this.note, resource.note) && Objects.equals((Object)this.operationalState, (Object)resource.operationalState) && Objects.equals(this.place, resource.place) && Objects.equals(this.relatedParty, resource.relatedParty) && Objects.equals(this.resourceCharacteristic, resource.resourceCharacteristic) && Objects.equals(this.resourceRelationship, resource.resourceRelationship) && Objects.equals(this.resourceSpecification, resource.resourceSpecification) && Objects.equals((Object)this.resourceStatus, (Object)resource.resourceStatus) && Objects.equals((Object)this.usageState, (Object)resource.usageState) && Objects.equals(this.baseType, resource.baseType) && Objects.equals(this.schemaLocation, resource.schemaLocation) && Objects.equals(this.type, resource.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.category, this.description, this.endOperatingDate, this.name, this.resourceVersion, this.startOperatingDate, this.activationFeature, this.administrativeState, this.attachment, this.note, this.operationalState, this.place, this.relatedParty, this.resourceCharacteristic, this.resourceRelationship, this.resourceSpecification, this.resourceStatus, this.usageState, this.baseType, this.schemaLocation, this.type});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Characteristic getResourceCharacteristicByName(String aName) {
        for (Characteristic c : this.resourceCharacteristic) {
            if (!c.getName().equals(aName)) continue;
            return c;
        }
        return null;
    }
}

