/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Related Entity reference. A related place defines a place described by reference or by value linked to a specific entity. The polymorphic attributes @type, @schemaLocation & @referredType are related to the place entity and not the RelatedPlaceRefOrValue class itself")
@Validated
@Entity(name="RIRelPlaceRefVal")
public class RelatedPlaceRefOrValue
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public RelatedPlaceRefOrValue id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the place")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RelatedPlaceRefOrValue role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="")
    @NotNull
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedPlaceRefOrValue _atBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
    }

    public RelatedPlaceRefOrValue _atSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
    }

    public RelatedPlaceRefOrValue _atType(String _atType) {
        this.type = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class Extensible name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String _atType) {
        this.type = _atType;
    }

    public RelatedPlaceRefOrValue _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedPlaceRefOrValue relatedPlaceRefOrValue = (RelatedPlaceRefOrValue)o;
        return Objects.equals(this.id, relatedPlaceRefOrValue.id) && Objects.equals(this.href, relatedPlaceRefOrValue.href) && Objects.equals(this.name, relatedPlaceRefOrValue.name) && Objects.equals(this.role, relatedPlaceRefOrValue.role) && Objects.equals(this.baseType, relatedPlaceRefOrValue.baseType) && Objects.equals(this.schemaLocation, relatedPlaceRefOrValue.schemaLocation) && Objects.equals(this.type, relatedPlaceRefOrValue.type) && Objects.equals(this._atReferredType, relatedPlaceRefOrValue._atReferredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.role, this.baseType, this.schemaLocation, this.type, this._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedPlaceRefOrValue {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

