/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.springframework.validation.annotation.Validated;

@Schema(description="Physical resource is a type of resource that describes the common set of attributes shared by all concrete physical resources (e.g. EQUIPMENT) in the inventory.")
@Validated
@Entity(name="RIPhysicalRes")
public class PhysicalResource
extends Resource {
    private OffsetDateTime manufactureDate = null;
    @JsonProperty(value="powerState")
    private String powerState = null;
    @JsonProperty(value="serialNumber")
    private String serialNumber = null;
    @JsonProperty(value="versionNumber")
    private String versionNumber = null;

    public PhysicalResource manufactureDate(OffsetDateTime manufactureDate) {
        this.manufactureDate = manufactureDate;
        return this;
    }

    @Schema(description="This is a string attribute that defines the date of manufacture of this item in the fixed format \"dd/mm/yyyy\". This is an optional attribute.")
    @Valid
    public OffsetDateTime getManufactureDate() {
        return this.manufactureDate;
    }

    public void setManufactureDate(OffsetDateTime manufactureDate) {
        this.manufactureDate = manufactureDate;
    }

    @JsonProperty(value="manufactureDate")
    public String getManufactureDateStr() {
        if (this.manufactureDate != null) {
            return this.manufactureDate.toString();
        }
        return null;
    }

    public void setManufactureDate(String endDate) {
        if (endDate != null) {
            this.manufactureDate = OffsetDateTime.parse(endDate);
        }
    }

    public PhysicalResource powerState(String powerState) {
        this.powerState = powerState;
        return this;
    }

    @Schema(description="This defines the current power status of the hardware item. Values include:    0:  Unknown   1:  Not Applicable   2:  No Power Applied   3: Full Power Applied   4:  Power Save - Normal   5:  Power Save - Degraded   6:  Power Save - Standby   7:  Power Save - Critical   8:  Power Save - Low Power Mode   9:  Power Save - Unknown  10: Power Cycle  11: Power Warning  12: Power Off")
    public String getPowerState() {
        return this.powerState;
    }

    public void setPowerState(String powerState) {
        this.powerState = powerState;
    }

    @Override
    public PhysicalResource resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Override
    @Schema(description="A field that identifies the specific version of an instance of a resource.")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public PhysicalResource serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Schema(description="This is a string that represents a manufacturer-allocated number used to identify different instances of the same hardware item. The ModelNumber and PartNumber attributes are used to identify different types of hardware items. This is a REQUIRED attribute.")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Override
    public PhysicalResource startOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
        return this;
    }

    @Override
    @Schema(description="A date time( DateTime). The date from which the resource is operating")
    @Valid
    public OffsetDateTime getStartOperatingDate() {
        return this.startOperatingDate;
    }

    @Override
    public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
    }

    public PhysicalResource versionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    @Schema(description="This is a string that identifies the version of this physical resource. This is an optional attribute.")
    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalResource physicalResource = (PhysicalResource)o;
        return Objects.equals(this.id, physicalResource.id) && Objects.equals(this.href, physicalResource.href) && Objects.equals(this.category, physicalResource.category) && Objects.equals(this.description, physicalResource.description) && Objects.equals(this.endOperatingDate, physicalResource.endOperatingDate) && Objects.equals(this.manufactureDate, physicalResource.manufactureDate) && Objects.equals(this.name, physicalResource.name) && Objects.equals(this.powerState, physicalResource.powerState) && Objects.equals(this.resourceVersion, physicalResource.resourceVersion) && Objects.equals(this.serialNumber, physicalResource.serialNumber) && Objects.equals(this.startOperatingDate, physicalResource.startOperatingDate) && Objects.equals(this.versionNumber, physicalResource.versionNumber) && Objects.equals(this.activationFeature, physicalResource.activationFeature) && Objects.equals((Object)this.administrativeState, (Object)physicalResource.administrativeState) && Objects.equals(this.attachment, physicalResource.attachment) && Objects.equals(this.note, physicalResource.note) && Objects.equals((Object)this.operationalState, (Object)physicalResource.operationalState) && Objects.equals(this.place, physicalResource.place) && Objects.equals(this.relatedParty, physicalResource.relatedParty) && Objects.equals(this.resourceCharacteristic, physicalResource.resourceCharacteristic) && Objects.equals(this.resourceRelationship, physicalResource.resourceRelationship) && Objects.equals(this.resourceSpecification, physicalResource.resourceSpecification) && Objects.equals((Object)this.resourceStatus, (Object)physicalResource.resourceStatus) && Objects.equals((Object)this.usageState, (Object)physicalResource.usageState) && Objects.equals(this.baseType, physicalResource.baseType) && Objects.equals(this.schemaLocation, physicalResource.schemaLocation) && Objects.equals(this.type, physicalResource.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.category, this.description, this.endOperatingDate, this.manufactureDate, this.name, this.powerState, this.resourceVersion, this.serialNumber, this.startOperatingDate, this.versionNumber, this.activationFeature, this.administrativeState, this.attachment, this.note, this.operationalState, this.place, this.relatedParty, this.resourceCharacteristic, this.resourceRelationship, this.resourceSpecification, this.resourceStatus, this.usageState, this.baseType, this.schemaLocation, this.type});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhysicalResource {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    manufactureDate: ").append(this.toIndentedString(this.manufactureDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    powerState: ").append(this.toIndentedString(this.powerState)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

