/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.springframework.validation.annotation.Validated;

@Schema(description="Logic resource is a type of resource that describes the common set of attributes shared by all concrete logical resources (e.g. TPE, MSISDN, IP Addresses) in the inventory.")
@Validated
@Entity(name="RILogicalRes")
public class LogicalResource
extends Resource {
    @JsonProperty(value="value")
    private String value = null;

    public LogicalResource value(String value) {
        this.value = value;
        return this;
    }

    @Schema(description="the value of the logical resource. E.g '0746712345' for  MSISDN's")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalResource logicalResource = (LogicalResource)o;
        return Objects.equals(this.id, logicalResource.id) && Objects.equals(this.href, logicalResource.href) && Objects.equals(this.category, logicalResource.category) && Objects.equals(this.description, logicalResource.description) && Objects.equals(this.endOperatingDate, logicalResource.endOperatingDate) && Objects.equals(this.name, logicalResource.name) && Objects.equals(this.resourceVersion, logicalResource.resourceVersion) && Objects.equals(this.startOperatingDate, logicalResource.startOperatingDate) && Objects.equals(this.value, logicalResource.value) && Objects.equals(this.activationFeature, logicalResource.activationFeature) && Objects.equals((Object)this.administrativeState, (Object)logicalResource.administrativeState) && Objects.equals(this.attachment, logicalResource.attachment) && Objects.equals(this.note, logicalResource.note) && Objects.equals((Object)this.operationalState, (Object)logicalResource.operationalState) && Objects.equals(this.place, logicalResource.place) && Objects.equals(this.relatedParty, logicalResource.relatedParty) && Objects.equals(this.resourceCharacteristic, logicalResource.resourceCharacteristic) && Objects.equals(this.resourceRelationship, logicalResource.resourceRelationship) && Objects.equals(this.resourceSpecification, logicalResource.resourceSpecification) && Objects.equals((Object)this.resourceStatus, (Object)logicalResource.resourceStatus) && Objects.equals((Object)this.usageState, (Object)logicalResource.usageState) && Objects.equals(this.baseType, logicalResource.baseType) && Objects.equals(this.schemaLocation, logicalResource.schemaLocation) && Objects.equals(this.type, logicalResource.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.category, this.description, this.endOperatingDate, this.name, this.resourceVersion, this.startOperatingDate, this.value, this.activationFeature, this.administrativeState, this.attachment, this.note, this.operationalState, this.place, this.relatedParty, this.resourceCharacteristic, this.resourceRelationship, this.resourceSpecification, this.resourceStatus, this.usageState, this.baseType, this.schemaLocation, this.type});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogicalResource {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

