/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Configuration feature")
@Validated
@Entity(name="RIFeatureRel")
public class FeatureRelationship
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public FeatureRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the target feature.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeatureRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="This is the type of the feature relationship.")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public FeatureRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureRelationship featureRelationship = (FeatureRelationship)o;
        return Objects.equals(this.id, featureRelationship.id) && Objects.equals(this.name, featureRelationship.name) && Objects.equals(this.relationshipType, featureRelationship.relationshipType) && Objects.equals(this.validFor, featureRelationship.validFor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.relationshipType, this.validFor);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

