/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.ri639.model.Characteristic;
import org.etsi.osl.tmf.ri639.model.ConstraintRef;
import org.etsi.osl.tmf.ri639.model.FeatureRelationship;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.validation.annotation.Validated;

@Schema(description="Configuration feature.")
@Validated
@Entity(name="RIFeature")
public class Feature {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    protected String uuid = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="constraint")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ConstraintRef> constraint = new HashSet<ConstraintRef>();
    @JsonProperty(value="featureCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> featureCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="featureRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<FeatureRelationship> featureRelationship = new HashSet<FeatureRelationship>();

    @Schema(description="Unique identifier of the feature.")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public Feature isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="True if this is a feature group. Default is false.")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public Feature isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(description="True if this feature is enabled. Default is true.")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Feature name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="This is the name for the feature.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Feature constraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
        return this;
    }

    public Feature addConstraintItem(ConstraintRef constraintItem) {
        if (this.constraint == null) {
            this.constraint = new HashSet<ConstraintRef>();
        }
        this.constraint.add(constraintItem);
        return this;
    }

    @Schema(description="This is a list of feature constraints.")
    @Valid
    public Set<ConstraintRef> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
    }

    public Feature featureCharacteristic(Set<Characteristic> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
        return this;
    }

    public Feature addFeatureCharacteristicItem(Characteristic featureCharacteristicItem) {
        this.featureCharacteristic.add(featureCharacteristicItem);
        return this;
    }

    @Schema(description="This is a list of Characteristics for a particular feature.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) Set<Characteristic> getFeatureCharacteristic() {
        return this.featureCharacteristic;
    }

    public void setFeatureCharacteristic(Set<Characteristic> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
    }

    public Feature featureRelationship(Set<FeatureRelationship> featureRelationship) {
        this.featureRelationship = featureRelationship;
        return this;
    }

    public Feature addFeatureRelationshipItem(FeatureRelationship featureRelationshipItem) {
        if (this.featureRelationship == null) {
            this.featureRelationship = new HashSet<FeatureRelationship>();
        }
        this.featureRelationship.add(featureRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<FeatureRelationship> getFeatureRelationship() {
        return this.featureRelationship;
    }

    public void setFeatureRelationship(Set<FeatureRelationship> featureRelationship) {
        this.featureRelationship = featureRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equals(this.id, feature.id) && Objects.equals(this.isBundle, feature.isBundle) && Objects.equals(this.isEnabled, feature.isEnabled) && Objects.equals(this.name, feature.name) && Objects.equals(this.constraint, feature.constraint) && Objects.equals(this.featureCharacteristic, feature.featureCharacteristic) && Objects.equals(this.featureRelationship, feature.featureRelationship);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.isBundle, this.isEnabled, this.name, this.constraint, this.featureCharacteristic, this.featureRelationship);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Feature {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    featureCharacteristic: ").append(this.toIndentedString(this.featureCharacteristic)).append("\n");
        sb.append("    featureRelationship: ").append(this.toIndentedString(this.featureRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

