/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.ri639.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Another Characteristic that is related to the current Characteristic;")
@Validated
@Entity(name="RICharacteristicRel")
public class CharacteristicRelationship
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;

    public CharacteristicRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the characteristic")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public CharacteristicRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="The type of relationship")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicRelationship characteristicRelationship = (CharacteristicRelationship)o;
        return Objects.equals(this.id, characteristicRelationship.id) && Objects.equals(this.href, characteristicRelationship.href) && Objects.equals(this.relationshipType, characteristicRelationship.relationshipType) && Objects.equals(this.baseType, characteristicRelationship.baseType) && Objects.equals(this.schemaLocation, characteristicRelationship.schemaLocation) && Objects.equals(this.type, characteristicRelationship.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.relationshipType, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

