/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.FeatureSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristic;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristicValue;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRelationship;
import org.etsi.osl.tmf.rcm634.model.TargetResourceSchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resources are physical or non-physical components (or some combination of these) within an enterprise's infrastructure or inventory. They are typically consumed or used by services (for example a physical port assigned to a service) or contribute to the realization of a Product (for example, a SIM card). They can be drawn from the Application, Computing and Network domains, and include, for example, Network Elements, software, IT systems, content and information, and technology components. A ResourceSpecification is an abstract base class for representing a generic means for implementing a particular type of Resource. In essence, a ResourceSpecification defines the common attributes and relationships of a set of related Resources, while Resource defines a specific instance that is based on a particular ResourceSpecification. Skipped properties: id,href")
@Validated
public class ResourceSpecificationUpdate {
    @JsonProperty(value="category")
    protected String category = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="attachment")
    @Valid
    protected List<AttachmentRefOrValue> attachment = null;
    @JsonProperty(value="featureSpecification")
    @Valid
    protected List<FeatureSpecification> featureSpecification = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="resourceSpecCharacteristic")
    @Valid
    protected List<ResourceSpecificationCharacteristic> resourceSpecificationCharacteristic = null;
    @JsonProperty(value="resourceSpecRelationship")
    @Valid
    protected List<ResourceSpecificationRelationship> resourceSpecificationRelationship = null;
    @JsonProperty(value="targetResourceSchema")
    protected TargetResourceSchema targetResourceSchema = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ResourceSpecificationUpdate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Category of the target resource like NetworkConnectivity, PhysicalLinks, Generic, L2Network and so on.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceSpecificationUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of this REST resource")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSpecificationUpdate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="A flag indicates that if this resource specification is a bundled specification (true) or single (false).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ResourceSpecificationUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status of the resource specification")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ResourceSpecificationUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name given to this REST resource")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceSpecificationUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Resource Specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ResourceSpecificationUpdate attachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ResourceSpecificationUpdate addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Complements the description of an element (for instance a resource) through video, pictures ...")
    @Valid
    public List<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ResourceSpecificationUpdate featureSpecification(List<FeatureSpecification> featureSpecification) {
        this.featureSpecification = featureSpecification;
        return this;
    }

    public ResourceSpecificationUpdate addFeatureSpecificationItem(FeatureSpecification featureSpecificationItem) {
        if (this.featureSpecification == null) {
            this.featureSpecification = new ArrayList<FeatureSpecification>();
        }
        this.featureSpecification.add(featureSpecificationItem);
        return this;
    }

    @Schema(description="A list of Features for this specification.")
    @Valid
    public List<FeatureSpecification> getFeatureSpecification() {
        return this.featureSpecification;
    }

    public void setFeatureSpecification(List<FeatureSpecification> featureSpecification) {
        this.featureSpecification = featureSpecification;
    }

    public ResourceSpecificationUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceSpecificationUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A related party defines party or party role linked to a specific entity.")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceSpecificationUpdate ResourceSpecificationCharacteristic(List<ResourceSpecificationCharacteristic> ResourceSpecificationCharacteristic2) {
        this.resourceSpecificationCharacteristic = ResourceSpecificationCharacteristic2;
        return this;
    }

    public ResourceSpecificationUpdate addResourceSpecificationCharacteristicItem(ResourceSpecificationCharacteristic ResourceSpecificationCharacteristicItem) {
        if (this.resourceSpecificationCharacteristic == null) {
            this.resourceSpecificationCharacteristic = new ArrayList<ResourceSpecificationCharacteristic>();
        }
        this.resourceSpecificationCharacteristic.add(ResourceSpecificationCharacteristicItem);
        return this;
    }

    public ResourceSpecificationUpdate addResourceSpecificationCharacteristicItemShort(String name, String defaultValue, String valueType, String description, Boolean isConfigurable) {
        ResourceSpecificationCharacteristic ci = new ResourceSpecificationCharacteristic();
        ci.name(name).description(description).valueType(valueType);
        if (defaultValue != null) {
            ResourceSpecificationCharacteristicValue val = new ResourceSpecificationCharacteristicValue();
            val.setValue(new Any(defaultValue, null));
            val.isDefault(true);
            ci.getResourceSpecCharacteristicValue().add(val);
        }
        ci.configurable(isConfigurable);
        return this.addResourceSpecificationCharacteristicItem(ci);
    }

    @Schema(description="A characteristic quality or distinctive feature of a ResourceSpecification.  The characteristic can be take on a discrete value, such as color, can take on a range of values, (for example, sensitivity of 100-240 mV), or can be derived from a formula (for example, usage time (hrs) = 30 - talk time *3). Certain characteristics, such as color, may be configured during the ordering or some other process.")
    @Valid
    public List<ResourceSpecificationCharacteristic> getResourceSpecificationCharacteristic() {
        return this.resourceSpecificationCharacteristic;
    }

    public void setResourceSpecificationCharacteristic(List<ResourceSpecificationCharacteristic> ResourceSpecificationCharacteristic2) {
        this.resourceSpecificationCharacteristic = ResourceSpecificationCharacteristic2;
    }

    public ResourceSpecificationUpdate resourceSpecificationRelationship(List<ResourceSpecificationRelationship> resourceSpecRelationship) {
        this.resourceSpecificationRelationship = resourceSpecRelationship;
        return this;
    }

    public ResourceSpecificationUpdate addResourceSpecificationRelationshipItem(ResourceSpecificationRelationship resourceSpecRelationshipItem) {
        if (this.resourceSpecificationRelationship == null) {
            this.resourceSpecificationRelationship = new ArrayList<ResourceSpecificationRelationship>();
        }
        this.resourceSpecificationRelationship.add(resourceSpecRelationshipItem);
        return this;
    }

    @Schema(description="A migration, substitution, dependency or exclusivity relationship between/among resource specifications.")
    @Valid
    public List<ResourceSpecificationRelationship> getResourceSpecificationRelationship() {
        return this.resourceSpecificationRelationship;
    }

    public void setResourceSpecificationRelationship(List<ResourceSpecificationRelationship> resourceSpecRelationship) {
        this.resourceSpecificationRelationship = resourceSpecRelationship;
    }

    public ResourceSpecificationUpdate targetResourceSchema(TargetResourceSchema targetResourceSchema) {
        this.targetResourceSchema = targetResourceSchema;
        return this;
    }

    @Schema(description="")
    @Valid
    public TargetResourceSchema getTargetResourceSchema() {
        return this.targetResourceSchema;
    }

    public void setTargetResourceSchema(TargetResourceSchema targetResourceSchema) {
        this.targetResourceSchema = targetResourceSchema;
    }

    public ResourceSpecificationUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceSpecificationUpdate baseType(String _atBaseType) {
        this.baseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String _atBaseType) {
        this.baseType = _atBaseType;
    }

    public ResourceSpecificationUpdate schemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String _atSchemaLocation) {
        this.schemaLocation = _atSchemaLocation;
    }

    public ResourceSpecificationUpdate type(String _atType) {
        this.type = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String _atType) {
        this.type = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationUpdate resourceSpecificationUpdate = (ResourceSpecificationUpdate)o;
        return Objects.equals(this.category, resourceSpecificationUpdate.category) && Objects.equals(this.description, resourceSpecificationUpdate.description) && Objects.equals(this.isBundle, resourceSpecificationUpdate.isBundle) && Objects.equals(this.lifecycleStatus, resourceSpecificationUpdate.lifecycleStatus) && Objects.equals(this.name, resourceSpecificationUpdate.name) && Objects.equals(this.version, resourceSpecificationUpdate.version) && Objects.equals(this.attachment, resourceSpecificationUpdate.attachment) && Objects.equals(this.featureSpecification, resourceSpecificationUpdate.featureSpecification) && Objects.equals(this.relatedParty, resourceSpecificationUpdate.relatedParty) && Objects.equals(this.resourceSpecificationCharacteristic, resourceSpecificationUpdate.resourceSpecificationCharacteristic) && Objects.equals(this.resourceSpecificationRelationship, resourceSpecificationUpdate.resourceSpecificationRelationship) && Objects.equals(this.targetResourceSchema, resourceSpecificationUpdate.targetResourceSchema) && Objects.equals(this.validFor, resourceSpecificationUpdate.validFor) && Objects.equals(this.baseType, resourceSpecificationUpdate.baseType) && Objects.equals(this.schemaLocation, resourceSpecificationUpdate.schemaLocation) && Objects.equals(this.type, resourceSpecificationUpdate.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecificationUpdate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    featureSpecification: ").append(this.toIndentedString(this.featureSpecification)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    ResourceSpecificationCharacteristic: ").append(this.toIndentedString(this.resourceSpecificationCharacteristic)).append("\n");
        sb.append("    resourceSpecRelationship: ").append(this.toIndentedString(this.resourceSpecificationRelationship)).append("\n");
        sb.append("    targetResourceSchema: ").append(this.toIndentedString(this.targetResourceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    protected String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void addResourceSpecificationRelationshipWith(ResourceSpecification responsesSpec1) {
        ResourceSpecificationRelationship r1 = new ResourceSpecificationRelationship();
        r1.setId(responsesSpec1.getId());
        r1.setName(responsesSpec1.getName());
        r1.setRole("serviceSpecRelationship");
        r1.setRelationshipType("aggregation");
        this.addResourceSpecificationRelationshipItem(r1);
    }
}

