/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristic;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.validation.annotation.Validated;

@Schema(description="A migration, substitution, dependency or exclusivity relationship between/among resource specifications.")
@Validated
@Entity(name="ResourceSpecRelationship")
public class ResourceSpecificationRelationship {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    protected String uuid = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="defaultQuantity")
    private Integer defaultQuantity = null;
    @JsonProperty(value="maximumQuantity")
    private Integer maximumQuantity = null;
    @JsonProperty(value="minimumQuantity")
    private Integer minimumQuantity = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="resourceSpecCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ResourceSpecificationCharacteristic> characteristic = new HashSet<ResourceSpecificationCharacteristic>();
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ResourceSpecificationRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of target ResourceSpecification")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceSpecificationRelationship href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Reference of the target ResourceSpecification")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ResourceSpecificationRelationship defaultQuantity(Integer defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
        return this;
    }

    @Schema(description="The default number of the related resource that should be instantiated, for example a rack would typically have 4 cards, although it could support more.")
    public Integer getDefaultQuantity() {
        return this.defaultQuantity;
    }

    public void setDefaultQuantity(Integer defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
    }

    public ResourceSpecificationRelationship maximumQuantity(Integer maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
        return this;
    }

    @Schema(description="The maximum number of the related resource that should be instantiated, for example a rack supports a maximum of 16 cards")
    public Integer getMaximumQuantity() {
        return this.maximumQuantity;
    }

    public void setMaximumQuantity(Integer maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
    }

    public ResourceSpecificationRelationship minimumQuantity(Integer minimumQuantity) {
        this.minimumQuantity = minimumQuantity;
        return this;
    }

    @Schema(description="The minimum number of the related resource that should be instantiated, for example a rack must have at least 1 card")
    public Integer getMinimumQuantity() {
        return this.minimumQuantity;
    }

    public void setMinimumQuantity(Integer minimumQuantity) {
        this.minimumQuantity = minimumQuantity;
    }

    public ResourceSpecificationRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name given to the target resource specification instance")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceSpecificationRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ResourceSpecificationRelationship role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="The association role for this resource specification")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ResourceSpecificationRelationship characteristic(Set<ResourceSpecificationCharacteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public ResourceSpecificationRelationship addCharacteristicItem(ResourceSpecificationCharacteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new HashSet<ResourceSpecificationCharacteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Schema(description="A characteristic that refines the relationship. For example, consider the relationship between a slot and a card. For a half-height card it is important to know the position at which the card is inserted, so a characteristic Position might be defined on the relationship to allow capturing of this in the inventory")
    @Valid
    public Set<ResourceSpecificationCharacteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(Set<ResourceSpecificationCharacteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public ResourceSpecificationRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceSpecificationRelationship _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceSpecificationRelationship _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceSpecificationRelationship _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationRelationship resourceSpecificationRelationship = (ResourceSpecificationRelationship)o;
        return Objects.equals(this.id, resourceSpecificationRelationship.id) && Objects.equals(this.href, resourceSpecificationRelationship.href) && Objects.equals(this.defaultQuantity, resourceSpecificationRelationship.defaultQuantity) && Objects.equals(this.maximumQuantity, resourceSpecificationRelationship.maximumQuantity) && Objects.equals(this.minimumQuantity, resourceSpecificationRelationship.minimumQuantity) && Objects.equals(this.name, resourceSpecificationRelationship.name) && Objects.equals(this.relationshipType, resourceSpecificationRelationship.relationshipType) && Objects.equals(this.role, resourceSpecificationRelationship.role) && Objects.equals(this.characteristic, resourceSpecificationRelationship.characteristic) && Objects.equals(this.validFor, resourceSpecificationRelationship.validFor) && Objects.equals(this._atBaseType, resourceSpecificationRelationship._atBaseType) && Objects.equals(this._atSchemaLocation, resourceSpecificationRelationship._atSchemaLocation) && Objects.equals(this._atType, resourceSpecificationRelationship._atType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.defaultQuantity, this.maximumQuantity, this.minimumQuantity, this.name, this.relationshipType, this.role, this.characteristic, this.validFor, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecificationRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    defaultQuantity: ").append(this.toIndentedString(this.defaultQuantity)).append("\n");
        sb.append("    maximumQuantity: ").append(this.toIndentedString(this.maximumQuantity)).append("\n");
        sb.append("    minimumQuantity: ").append(this.toIndentedString(this.minimumQuantity)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

