/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resource Specification reference: The ResourceSpecification is required to realize a ProductSpecification.")
@Validated
@Entity(name="ResourceSpecificationRef")
@JsonIgnoreProperties(value={"uuid"})
public class ResourceSpecificationRef
extends BaseRootNamedEntity {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;
    @JsonProperty(value="id")
    protected String id = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceSpecificationRef() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public ResourceSpecificationRef(ResourceSpecificationRef r) {
        this();
        this.name = r.name;
        this.version = r.version;
        this.id = r.id;
    }

    public ResourceSpecificationRef id(String id) {
        this.id = id;
        return this;
    }

    public ResourceSpecificationRef version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Resource specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public ResourceSpecificationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationRef resourceSpecificationRef = (ResourceSpecificationRef)o;
        return Objects.equals(this.id, resourceSpecificationRef.id) && Objects.equals(this.href, resourceSpecificationRef.href) && Objects.equals(this.name, resourceSpecificationRef.name) && Objects.equals(this.version, resourceSpecificationRef.version) && Objects.equals(this.baseType, resourceSpecificationRef.baseType) && Objects.equals(this.schemaLocation, resourceSpecificationRef.schemaLocation) && Objects.equals(this.type, resourceSpecificationRef.type) && Objects.equals(this.referredType, resourceSpecificationRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

