/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resources are physical or non-physical components (or some combination of these) within an enterprise's infrastructure or inventory. They are typically consumed or used by services (for example a physical port assigned to a service) or contribute to the realization of a Product (for example, a SIM card). They can be drawn from the Application, Computing and Network domains, and include, for example, Network Elements, software, IT systems, content and information, and technology components. A ResourceSpecification is an abstract base class for representing a generic means for implementing a particular type of Resource. In essence, a ResourceSpecification defines the common attributes and relationships of a set of related Resources, while Resource defines a specific instance that is based on a particular ResourceSpecification. Skipped properties: id,href")
@Validated
public class ResourceSpecificationCreate
extends ResourceSpecificationUpdate {
    @Override
    public ResourceSpecificationCreate name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationCreate resourceSpecificationCreate = (ResourceSpecificationCreate)o;
        return Objects.equals(this.name, resourceSpecificationCreate.name) && Objects.equals(this.description, resourceSpecificationCreate.description) && Objects.equals(this.type, resourceSpecificationCreate.type) && Objects.equals(this.schemaLocation, resourceSpecificationCreate.schemaLocation) && Objects.equals(this.baseType, resourceSpecificationCreate.baseType) && Objects.equals(this.version, resourceSpecificationCreate.version) && Objects.equals(this.validFor, resourceSpecificationCreate.validFor) && Objects.equals(this.lifecycleStatus, resourceSpecificationCreate.lifecycleStatus) && Objects.equals(this.isBundle, resourceSpecificationCreate.isBundle) && Objects.equals(this.category, resourceSpecificationCreate.category) && Objects.equals(this.targetResourceSchema, resourceSpecificationCreate.targetResourceSchema) && Objects.equals(this.featureSpecification, resourceSpecificationCreate.featureSpecification) && Objects.equals(this.attachment, resourceSpecificationCreate.attachment) && Objects.equals(this.relatedParty, resourceSpecificationCreate.relatedParty) && Objects.equals(this.resourceSpecificationCharacteristic, resourceSpecificationCreate.resourceSpecificationCharacteristic) && Objects.equals(this.resourceSpecificationRelationship, resourceSpecificationCreate.resourceSpecificationRelationship);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecificationCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    targetResourceSchema: ").append(this.toIndentedString(this.targetResourceSchema)).append("\n");
        sb.append("    featureSpecification: ").append(this.toIndentedString(this.featureSpecification)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecCharacteristic: ").append(this.toIndentedString(this.resourceSpecificationCharacteristic)).append("\n");
        sb.append("    resourceSpecRelationship: ").append(this.toIndentedString(this.resourceSpecificationRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

