/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A number or text that can be assigned to a ResourceSpecCharacteristic.")
@Validated
@Entity(name="ResourceSpecCharacteristicValue")
public class ResourceSpecificationCharacteristicValue
extends BaseRootEntity {
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="isDefault")
    private Boolean isDefault = null;
    @JsonProperty(value="value")
    private Any value = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="valueFrom")
    private Integer valueFrom = null;
    @JsonProperty(value="valueTo")
    private Integer valueTo = null;
    @JsonProperty(value="rangeInterval")
    private String rangeInterval = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;

    public ResourceSpecificationCharacteristicValue() {
    }

    public ResourceSpecificationCharacteristicValue(ResourceSpecificationCharacteristicValue r) {
        this();
        this.isDefault = r.isDefault;
        this.rangeInterval = r.rangeInterval;
        this.regex = r.regex;
        this.unitOfMeasure = r.unitOfMeasure;
        this.valueFrom = r.valueFrom;
        this.valueTo = r.valueTo;
        this.valueType = r.valueType;
        this.validFor = new TimePeriod(r.validFor);
        if (r.value != null) {
            this.value = new Any(r.value.getValue(), r.value.getAlias());
        }
        this.baseType = r.baseType;
    }

    public ResourceSpecificationCharacteristicValue valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic value can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ResourceSpecificationCharacteristicValue isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Schema(description="If true, the Boolean Indicates if the value is the default value for a characteristic")
    public Boolean isIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ResourceSpecificationCharacteristicValue value(Any value) {
        this.value = value;
        return this;
    }

    @Schema(description="The value that the characteristic can take on. If the value is a complex type, the definition of the type should be found by the link as defined in @schemaLocation")
    public Any getValue() {
        return this.value;
    }

    public void setValue(Any value) {
        this.value = value;
    }

    public ResourceSpecificationCharacteristicValue unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="A length, surface, volume, dry measure, liquid measure, money, weight, time, and the like. In general, a determinate quantity or magnitude of the kind designated, taken as a standard of comparison for others of the same kind, in assigning to them numerical values, as 1 foot, 1 yard, 1 mile, 1 square foot.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public ResourceSpecificationCharacteristicValue validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time for which a value is applicable.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceSpecificationCharacteristicValue valueFrom(Integer valueFrom) {
        this.valueFrom = valueFrom;
        return this;
    }

    @Schema(description="The low range value that a characteristic can take on")
    public Integer getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(Integer valueFrom) {
        this.valueFrom = valueFrom;
    }

    public ResourceSpecificationCharacteristicValue valueTo(Integer valueTo) {
        this.valueTo = valueTo;
        return this;
    }

    @Schema(description="The upper range value that a characteristic can take on")
    public Integer getValueTo() {
        return this.valueTo;
    }

    public void setValueTo(Integer valueTo) {
        this.valueTo = valueTo;
    }

    public ResourceSpecificationCharacteristicValue rangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
        return this;
    }

    @Schema(description="An indicator that specifies the inclusion or exclusion of the valueFrom and valueTo attributes. If applicable, possible values are \"open\", \"closed\", \"closedBottom\" and \"closedTop\".")
    public String getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
    }

    public ResourceSpecificationCharacteristicValue regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A regular expression constraint for given value")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public ResourceSpecificationCharacteristicValue type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="The class type of a complex value type")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public ResourceSpecificationCharacteristicValue schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="This (optional) field provides a link to the schema describing the value type")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationCharacteristicValue resourceSpecCharacteristicValue = (ResourceSpecificationCharacteristicValue)o;
        return Objects.equals(this.valueType, resourceSpecCharacteristicValue.valueType) && Objects.equals(this.isDefault, resourceSpecCharacteristicValue.isDefault) && Objects.equals(this.value, resourceSpecCharacteristicValue.value) && Objects.equals(this.unitOfMeasure, resourceSpecCharacteristicValue.unitOfMeasure) && Objects.equals(this.validFor, resourceSpecCharacteristicValue.validFor) && Objects.equals(this.valueFrom, resourceSpecCharacteristicValue.valueFrom) && Objects.equals(this.valueTo, resourceSpecCharacteristicValue.valueTo) && Objects.equals(this.rangeInterval, resourceSpecCharacteristicValue.rangeInterval) && Objects.equals(this.regex, resourceSpecCharacteristicValue.regex) && Objects.equals(this.type, resourceSpecCharacteristicValue.type) && Objects.equals(this.schemaLocation, resourceSpecCharacteristicValue.schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecCharacteristicValue {\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    valueFrom: ").append(this.toIndentedString(this.valueFrom)).append("\n");
        sb.append("    valueTo: ").append(this.toIndentedString(this.valueTo)).append("\n");
        sb.append("    rangeInterval: ").append(this.toIndentedString(this.rangeInterval)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

