/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among ResourceSpecificationCharacteristics. The specification characteristic is embedded within the specification whose ID and href are in this entity, and identified by its ID.")
@Validated
public class ResourceSpecificationCharacteristicRelationship {
    @JsonProperty(value="characteristicSpecificationId")
    private String characteristicSpecificationId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="resourceSpecificationHref")
    private String resourceSpecificationHref = null;
    @JsonProperty(value="resourceSpecificationId")
    private String resourceSpecificationId = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String _atBaseType = null;
    @JsonProperty(value="@schemaLocation")
    private String _atSchemaLocation = null;
    @JsonProperty(value="@type")
    private String _atType = null;

    public ResourceSpecificationCharacteristicRelationship characteristicSpecificationId(String characteristicSpecificationId) {
        this.characteristicSpecificationId = characteristicSpecificationId;
        return this;
    }

    @Schema(description="Unique identifier of the characteristic within the specification")
    public String getCharacteristicSpecificationId() {
        return this.characteristicSpecificationId;
    }

    public void setCharacteristicSpecificationId(String characteristicSpecificationId) {
        this.characteristicSpecificationId = characteristicSpecificationId;
    }

    public ResourceSpecificationCharacteristicRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the target characteristic within the specification")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceSpecificationCharacteristicRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as aggregation, migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ResourceSpecificationCharacteristicRelationship resourceSpecificationHref(String resourceSpecificationHref) {
        this.resourceSpecificationHref = resourceSpecificationHref;
        return this;
    }

    @Schema(description="Hyperlink reference to the resource specification containing the target characteristic")
    public String getResourceSpecificationHref() {
        return this.resourceSpecificationHref;
    }

    public void setResourceSpecificationHref(String resourceSpecificationHref) {
        this.resourceSpecificationHref = resourceSpecificationHref;
    }

    public ResourceSpecificationCharacteristicRelationship resourceSpecificationId(String resourceSpecificationId) {
        this.resourceSpecificationId = resourceSpecificationId;
        return this;
    }

    @Schema(description="Unique identifier of the resource specification containing the target characteristic")
    public String getResourceSpecificationId() {
        return this.resourceSpecificationId;
    }

    public void setResourceSpecificationId(String resourceSpecificationId) {
        this.resourceSpecificationId = resourceSpecificationId;
    }

    public ResourceSpecificationCharacteristicRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceSpecificationCharacteristicRelationship _atBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this._atBaseType;
    }

    public void setAtBaseType(String _atBaseType) {
        this._atBaseType = _atBaseType;
    }

    public ResourceSpecificationCharacteristicRelationship _atSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this._atSchemaLocation;
    }

    public void setAtSchemaLocation(String _atSchemaLocation) {
        this._atSchemaLocation = _atSchemaLocation;
    }

    public ResourceSpecificationCharacteristicRelationship _atType(String _atType) {
        this._atType = _atType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this._atType;
    }

    public void setAtType(String _atType) {
        this._atType = _atType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationCharacteristicRelationship resourceSpecificationCharacteristicRelationship = (ResourceSpecificationCharacteristicRelationship)o;
        return Objects.equals(this.characteristicSpecificationId, resourceSpecificationCharacteristicRelationship.characteristicSpecificationId) && Objects.equals(this.name, resourceSpecificationCharacteristicRelationship.name) && Objects.equals(this.relationshipType, resourceSpecificationCharacteristicRelationship.relationshipType) && Objects.equals(this.resourceSpecificationHref, resourceSpecificationCharacteristicRelationship.resourceSpecificationHref) && Objects.equals(this.resourceSpecificationId, resourceSpecificationCharacteristicRelationship.resourceSpecificationId) && Objects.equals(this.validFor, resourceSpecificationCharacteristicRelationship.validFor) && Objects.equals(this._atBaseType, resourceSpecificationCharacteristicRelationship._atBaseType) && Objects.equals(this._atSchemaLocation, resourceSpecificationCharacteristicRelationship._atSchemaLocation) && Objects.equals(this._atType, resourceSpecificationCharacteristicRelationship._atType);
    }

    public int hashCode() {
        return Objects.hash(this.characteristicSpecificationId, this.name, this.relationshipType, this.resourceSpecificationHref, this.resourceSpecificationId, this.validFor, this._atBaseType, this._atSchemaLocation, this._atType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecificationCharacteristicRelationship {\n");
        sb.append("    characteristicSpecificationId: ").append(this.toIndentedString(this.characteristicSpecificationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    resourceSpecificationHref: ").append(this.toIndentedString(this.resourceSpecificationHref)).append("\n");
        sb.append("    resourceSpecificationId: ").append(this.toIndentedString(this.resourceSpecificationId)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this._atBaseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this._atSchemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this._atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

