/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecCharRelationship;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristicValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="This class defines the characteristic features of a resource specification. Every ResourceSpecification has a variety of important attributes, methods, constraints, and relationships, which distinguish a resource specification from other resource specifications.")
@Validated
@Entity(name="ResourceSpecCharacteristic")
public class ResourceSpecificationCharacteristic
extends BaseRootNamedEntity {
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@valueSchemaLocation")
    private String valueSchemaLocation = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="isUnique")
    private Boolean isUnique = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="extensible")
    private Boolean extensible = null;
    @JsonProperty(value="resourceSpecCharRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceSpecCharRelationship> resourceSpecCharRelationship = new HashSet<ResourceSpecCharRelationship>();
    @JsonProperty(value="resourceSpecCharacteristicValue")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceSpecificationCharacteristicValue> resourceSpecCharacteristicValue = new HashSet<ResourceSpecificationCharacteristicValue>();

    public ResourceSpecificationCharacteristic() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public ResourceSpecificationCharacteristic(ResourceSpecificationCharacteristic src) {
        this();
        this.configurable = src.configurable;
        this.description = src.description;
        this.extensible = src.extensible;
        this.isUnique = src.isUnique;
        this.maxCardinality = src.maxCardinality;
        this.minCardinality = src.minCardinality;
        this.name = src.name;
        this.regex = src.regex;
        this.valueType = src.valueType;
        this.validFor = new TimePeriod(src.validFor);
        if (src.resourceSpecCharRelationship != null) {
            for (ResourceSpecCharRelationship resourceSpecCharRelationship : src.resourceSpecCharRelationship) {
                this.addResourceSpecCharRelationshipItem(new ResourceSpecCharRelationship(resourceSpecCharRelationship));
            }
        }
        if (src.resourceSpecCharacteristicValue != null) {
            for (ResourceSpecificationCharacteristicValue resourceSpecificationCharacteristicValue : src.resourceSpecCharacteristicValue) {
                this.addResourceSpecCharacteristicValueItem(new ResourceSpecificationCharacteristicValue(resourceSpecificationCharacteristicValue));
            }
        }
    }

    @Override
    public ResourceSpecificationCharacteristic name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A word, term, or phrase by which this characteristic specification is known and distinguished from other characteristic specifications.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ResourceSpecificationCharacteristic description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains the CharacteristicSpecification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSpecificationCharacteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ResourceSpecificationCharacteristic configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @Schema(description="If true, the Boolean indicates that the ResourceSpecificationCharacteristic is configurable")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public ResourceSpecificationCharacteristic validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period of time for which a characteristic is applicable.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceSpecificationCharacteristic type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="(Class) type of the ResourceSpecificationCharacteristic")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public ResourceSpecificationCharacteristic schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(description="A link to the schema describing this characteristic specification")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceSpecificationCharacteristic valueSchemaLocation(String valueSchemaLocation) {
        this.valueSchemaLocation = valueSchemaLocation;
        return this;
    }

    @Schema(description="This (optional) field provides a link to the schema describing the value type")
    public String getValueSchemaLocation() {
        return this.valueSchemaLocation;
    }

    public void setValueSchemaLocation(String valueSchemaLocation) {
        this.valueSchemaLocation = valueSchemaLocation;
    }

    public ResourceSpecificationCharacteristic minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where zero is the value for the minCardinality.")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    public ResourceSpecificationCharacteristic maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where five is the value for the maxCardinality.")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public ResourceSpecificationCharacteristic isUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    @Schema(description="An indicator that specifies if a value is unique for the specification. Possible values are; \"unique while value is in effect\" and \"unique whether value is in effect or not\"")
    public Boolean isIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public ResourceSpecificationCharacteristic regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A rule or principle represented in regular expression used to derive the value of a characteristic value.")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public ResourceSpecificationCharacteristic extensible(Boolean extensible) {
        this.extensible = extensible;
        return this;
    }

    @Schema(description="An indicator that specifies that the values for the characteristic can be extended by adding new values when instantiating a characteristic for a resource.")
    public Boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean extensible) {
        this.extensible = extensible;
    }

    public ResourceSpecificationCharacteristic resourceSpecCharRelationship(Set<ResourceSpecCharRelationship> resourceSpecCharRelationship) {
        this.resourceSpecCharRelationship = resourceSpecCharRelationship;
        return this;
    }

    public ResourceSpecificationCharacteristic addResourceSpecCharRelationshipItem(ResourceSpecCharRelationship resourceSpecCharRelationshipItem) {
        if (this.resourceSpecCharRelationship == null) {
            this.resourceSpecCharRelationship = new HashSet<ResourceSpecCharRelationship>();
        }
        this.resourceSpecCharRelationship.add(resourceSpecCharRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ResourceSpecCharRelationship> getResourceSpecCharRelationship() {
        return this.resourceSpecCharRelationship;
    }

    public void setResourceSpecCharRelationship(Set<ResourceSpecCharRelationship> resourceSpecCharRelationship) {
        this.resourceSpecCharRelationship = resourceSpecCharRelationship;
    }

    public ResourceSpecificationCharacteristic ResourceSpecCharacteristicValue(Set<ResourceSpecificationCharacteristicValue> ResourceSpecificationCharacteristicValue2) {
        this.resourceSpecCharacteristicValue = ResourceSpecificationCharacteristicValue2;
        return this;
    }

    public ResourceSpecificationCharacteristic addResourceSpecCharacteristicValueItem(ResourceSpecificationCharacteristicValue ResourceSpecificationCharacteristicValueItem) {
        if (this.resourceSpecCharacteristicValue == null) {
            this.resourceSpecCharacteristicValue = new HashSet<ResourceSpecificationCharacteristicValue>();
        }
        this.resourceSpecCharacteristicValue.add(ResourceSpecificationCharacteristicValueItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<ResourceSpecificationCharacteristicValue> getResourceSpecCharacteristicValue() {
        return this.resourceSpecCharacteristicValue;
    }

    public void setResourceSpecificationCharacteristicValue(Set<ResourceSpecificationCharacteristicValue> ResourceSpecificationCharacteristicValue2) {
        this.resourceSpecCharacteristicValue = ResourceSpecificationCharacteristicValue2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecificationCharacteristic ResourceSpecificationCharacteristic2 = (ResourceSpecificationCharacteristic)o;
        return Objects.equals(this.name, ResourceSpecificationCharacteristic2.name) && Objects.equals(this.description, ResourceSpecificationCharacteristic2.description) && Objects.equals(this.valueType, ResourceSpecificationCharacteristic2.valueType) && Objects.equals(this.configurable, ResourceSpecificationCharacteristic2.configurable) && Objects.equals(this.validFor, ResourceSpecificationCharacteristic2.validFor) && Objects.equals(this.type, ResourceSpecificationCharacteristic2.type) && Objects.equals(this.schemaLocation, ResourceSpecificationCharacteristic2.schemaLocation) && Objects.equals(this.valueSchemaLocation, ResourceSpecificationCharacteristic2.valueSchemaLocation) && Objects.equals(this.minCardinality, ResourceSpecificationCharacteristic2.minCardinality) && Objects.equals(this.maxCardinality, ResourceSpecificationCharacteristic2.maxCardinality) && Objects.equals(this.isUnique, ResourceSpecificationCharacteristic2.isUnique) && Objects.equals(this.regex, ResourceSpecificationCharacteristic2.regex) && Objects.equals(this.extensible, ResourceSpecificationCharacteristic2.extensible) && Objects.equals(this.resourceSpecCharRelationship, ResourceSpecificationCharacteristic2.resourceSpecCharRelationship) && Objects.equals(this.resourceSpecCharacteristicValue, ResourceSpecificationCharacteristic2.resourceSpecCharacteristicValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecificationCharacteristic {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    valueSchemaLocation: ").append(this.toIndentedString(this.valueSchemaLocation)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    isUnique: ").append(this.toIndentedString(this.isUnique)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    extensible: ").append(this.toIndentedString(this.extensible)).append("\n");
        sb.append("    resourceSpecCharRelationship: ").append(this.toIndentedString(this.resourceSpecCharRelationship)).append("\n");
        sb.append("    ResourceSpecificationCharacteristicValue: ").append(this.toIndentedString(this.resourceSpecCharacteristicValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void updateWith(ResourceSpecificationCharacteristic src) {
        this.name = src.getName();
        this.description = src.getDescription();
        this.maxCardinality = src.getMaxCardinality();
        this.minCardinality = src.getMinCardinality();
        this.regex = src.getRegex();
        this.isUnique = src.isUnique;
        this.configurable = src.isConfigurable();
        this.extensible = src.isExtensible();
        this.updateResourceSpecificationCharacteristicValues(src.getResourceSpecCharacteristicValue());
        this.updateResourceSpecCharRelationships(src.getResourceSpecCharRelationship());
    }

    private void updateResourceSpecificationCharacteristicValues(@Valid Set<ResourceSpecificationCharacteristicValue> srcSet) {
        HashMap<Integer, Boolean> idAddedUpdated = new HashMap<Integer, Boolean>();
        for (ResourceSpecificationCharacteristicValue r : srcSet) {
            boolean valueExists = false;
            for (ResourceSpecificationCharacteristicValue thisCharVal : this.resourceSpecCharacteristicValue) {
                if (thisCharVal.hashCode() != r.hashCode()) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.hashCode(), true);
                break;
            }
            if (valueExists) continue;
            ResourceSpecificationCharacteristicValue nr = new ResourceSpecificationCharacteristicValue(r);
            this.addResourceSpecCharacteristicValueItem(nr);
            idAddedUpdated.put(nr.hashCode(), true);
        }
        ArrayList<ResourceSpecificationCharacteristicValue> toRemove = new ArrayList<ResourceSpecificationCharacteristicValue>();
        for (ResourceSpecificationCharacteristicValue ss : this.resourceSpecCharacteristicValue) {
            if (idAddedUpdated.get(ss.hashCode()) != null) continue;
            toRemove.add(ss);
        }
        for (ResourceSpecificationCharacteristicValue r : toRemove) {
            this.resourceSpecCharacteristicValue.remove(r);
        }
    }

    private void updateResourceSpecCharRelationships(@Valid Set<ResourceSpecCharRelationship> srcSet) {
        HashMap<String, Boolean> idAddedUpdated = new HashMap<String, Boolean>();
        for (ResourceSpecCharRelationship r : srcSet) {
            boolean valueExists = false;
            for (ResourceSpecCharRelationship thisCharVal : this.resourceSpecCharRelationship) {
                if (thisCharVal.getId() == null || !thisCharVal.getId().equals(r.getId())) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.getId(), true);
                break;
            }
            if (valueExists) continue;
            this.resourceSpecCharRelationship.add(new ResourceSpecCharRelationship(r));
            idAddedUpdated.put(r.getId(), true);
        }
        ArrayList<ResourceSpecCharRelationship> toRemove = new ArrayList<ResourceSpecCharRelationship>();
        for (ResourceSpecCharRelationship ss : this.resourceSpecCharRelationship) {
            if (idAddedUpdated.get(ss.getId()) != null) continue;
            toRemove.add(ss);
        }
        for (ResourceSpecCharRelationship r : toRemove) {
            this.resourceSpecCharRelationship.remove(r);
        }
    }
}

