/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.FeatureSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecCharRelationship;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristic;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRelationship;
import org.etsi.osl.tmf.rcm634.model.TargetResourceSchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resources are physical or non-physical components (or some combination of these) within an enterprise's infrastructure or inventory. They are typically consumed or used by services (for example a physical port assigned to a service) or contribute to the realization of a Product (for example, a SIM card). They can be drawn from the Application, Computing and Network domains, and include, for example, Network Elements, software, IT systems, content and information, and technology components. A ResourceSpecification is an abstract base class for representing a generic means for implementing a particular type of Resource. In essence, a ResourceSpecification defines the common attributes and relationships of a set of related Resources, while Resource defines a specific instance that is based on a particular ResourceSpecification.")
@Validated
@Entity(name="ResSpec")
public abstract class ResourceSpecification
extends BaseEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="category")
    protected String category = null;
    @JsonProperty(value="targetResourceSchema")
    protected TargetResourceSchema targetResourceSchema = null;
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<AttachmentRefOrValue> attachment = new HashSet<AttachmentRefOrValue>();
    @JsonProperty(value="featureSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<FeatureSpecification> featureSpecification = new HashSet<FeatureSpecification>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="resourceSpecCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ResourceSpecificationCharacteristic> resourceSpecCharacteristic = new HashSet<ResourceSpecificationCharacteristic>();
    @JsonProperty(value="resourceSpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Set<ResourceSpecificationRelationship> resourceSpecRelationship = new HashSet<ResourceSpecificationRelationship>();
    @JsonIgnore
    @Column(name="candidate_specid")
    private String resourceCandidateObjId;

    @Schema(description="Unique identifier of this REST resource")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.uuid;
    }

    public ResourceSpecification href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference to this REST resource")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public ResourceSpecification category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Category of the target resource like NetworkConnectivity, PhysicalLinks, Generic, L2Network and so on.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public ResourceSpecification description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @Schema(description="Description of this REST resource")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="A flag indicates that if this resource specification is a bundled specification (true) or single (false).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    @Override
    public ResourceSpecification lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Override
    @Schema(description="Used to indicate the current lifecycle status of the resource specification")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    @Override
    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    @Override
    public ResourceSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name given to this REST resource")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ResourceSpecification version(String version) {
        this.version = version;
        return this;
    }

    @Override
    @Schema(description="Resource Specification version")
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public ResourceSpecification attachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ResourceSpecification addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Complements the description of an element (for instance a resource) through video, pictures ...")
    @Valid
    public Set<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ResourceSpecification featureSpecification(Set<FeatureSpecification> featureSpecification) {
        this.featureSpecification = featureSpecification;
        return this;
    }

    public ResourceSpecification addFeatureSpecificationItem(FeatureSpecification featureSpecificationItem) {
        if (this.featureSpecification == null) {
            this.featureSpecification = new HashSet<FeatureSpecification>();
        }
        this.featureSpecification.add(featureSpecificationItem);
        return this;
    }

    @Schema(description="A list of Features for this specification.")
    @Valid
    public Set<FeatureSpecification> getFeatureSpecification() {
        return this.featureSpecification;
    }

    public void setFeatureSpecification(Set<FeatureSpecification> featureSpecification) {
        this.featureSpecification = featureSpecification;
    }

    public ResourceSpecification resourceSpecCharacteristic(Set<ResourceSpecificationCharacteristic> resourceSpecCharacteristic) {
        this.resourceSpecCharacteristic = resourceSpecCharacteristic;
        return this;
    }

    public ResourceSpecification addResourceSpecCharacteristicItem(ResourceSpecificationCharacteristic resourceSpecCharacteristicItem) {
        if (this.resourceSpecCharacteristic == null) {
            this.resourceSpecCharacteristic = new HashSet<ResourceSpecificationCharacteristic>();
        }
        this.resourceSpecCharacteristic.add(resourceSpecCharacteristicItem);
        return this;
    }

    @Schema(description="A characteristic quality or distinctive feature of a ResourceSpecification.  The characteristic can be take on a discrete value, such as color, can take on a range of values, (for example, sensitivity of 100-240 mV), or can be derived from a formula (for example, usage time (hrs) = 30 - talk time *3). Certain characteristics, such as color, may be configured during the ordering or some other process.")
    @Valid
    public Set<ResourceSpecificationCharacteristic> getResourceSpecCharacteristic() {
        return this.resourceSpecCharacteristic;
    }

    public void setResourceSpecCharacteristic(Set<ResourceSpecificationCharacteristic> resourceSpecCharacteristic) {
        this.resourceSpecCharacteristic = resourceSpecCharacteristic;
    }

    public ResourceSpecification resourceSpecRelationship(Set<ResourceSpecificationRelationship> resourceSpecRelationship) {
        this.resourceSpecRelationship = resourceSpecRelationship;
        return this;
    }

    public ResourceSpecification addResourceSpecRelationshipItem(ResourceSpecificationRelationship resourceSpecRelationshipItem) {
        if (this.resourceSpecRelationship == null) {
            this.resourceSpecRelationship = new HashSet<ResourceSpecificationRelationship>();
        }
        this.resourceSpecRelationship.add(resourceSpecRelationshipItem);
        return this;
    }

    public String getResourceCandidateObjId() {
        return this.resourceCandidateObjId;
    }

    public void setResourceCandidateObjId(String resourceCandidateObjId) {
        this.resourceCandidateObjId = resourceCandidateObjId;
    }

    @Schema(description="A migration, substitution, dependency or exclusivity relationship between/among resource specifications.")
    @Valid
    public Set<ResourceSpecificationRelationship> getResourceSpecRelationship() {
        return this.resourceSpecRelationship;
    }

    public void setResourceSpecRelationship(Set<ResourceSpecificationRelationship> resourceSpecRelationship) {
        this.resourceSpecRelationship = resourceSpecRelationship;
    }

    public ResourceSpecification targetResourceSchema(TargetResourceSchema targetResourceSchema) {
        this.targetResourceSchema = targetResourceSchema;
        return this;
    }

    @Schema(description="")
    @Valid
    public TargetResourceSchema getTargetResourceSchema() {
        return this.targetResourceSchema;
    }

    public void setTargetResourceSchema(TargetResourceSchema targetResourceSchema) {
        this.targetResourceSchema = targetResourceSchema;
    }

    @Override
    public ResourceSpecification baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public ResourceSpecification schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceSpecification type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecification resourceSpecification = (ResourceSpecification)o;
        return Objects.equals(this.id, resourceSpecification.id) && Objects.equals(this.href, resourceSpecification.href) && Objects.equals(this.category, resourceSpecification.category) && Objects.equals(this.description, resourceSpecification.description) && Objects.equals(this.isBundle, resourceSpecification.isBundle) && Objects.equals(this.lastUpdate, resourceSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceSpecification.lifecycleStatus) && Objects.equals(this.name, resourceSpecification.name) && Objects.equals(this.version, resourceSpecification.version) && Objects.equals(this.attachment, resourceSpecification.attachment) && Objects.equals(this.featureSpecification, resourceSpecification.featureSpecification) && Objects.equals(this.relatedParty, resourceSpecification.relatedParty) && Objects.equals(this.resourceSpecCharacteristic, resourceSpecification.resourceSpecCharacteristic) && Objects.equals(this.resourceSpecRelationship, resourceSpecification.resourceSpecRelationship) && Objects.equals(this.targetResourceSchema, resourceSpecification.targetResourceSchema) && Objects.equals(this.validFor, resourceSpecification.validFor) && Objects.equals(this.baseType, resourceSpecification.baseType) && Objects.equals(this.schemaLocation, resourceSpecification.schemaLocation) && Objects.equals(this.type, resourceSpecification.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.category, this.description, this.isBundle, this.lastUpdate, this.lifecycleStatus, this.name, this.version, this.attachment, this.featureSpecification, this.relatedParty, this.resourceSpecCharacteristic, this.resourceSpecRelationship, this.targetResourceSchema, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    featureSpecification: ").append(this.toIndentedString(this.featureSpecification)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecCharacteristic: ").append(this.toIndentedString(this.resourceSpecCharacteristic)).append("\n");
        sb.append("    resourceSpecRelationship: ").append(this.toIndentedString(this.resourceSpecRelationship)).append("\n");
        sb.append("    targetResourceSchema: ").append(this.toIndentedString(this.targetResourceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void fixResourceCharRelationhsipIDs() {
        for (ResourceSpecificationCharacteristic schar : this.resourceSpecCharacteristic) {
            for (ResourceSpecCharRelationship charRel : schar.getResourceSpecCharRelationship()) {
                if (charRel.getId() == null) {
                    for (ResourceSpecificationCharacteristic searchChar : this.resourceSpecCharacteristic) {
                        if (!searchChar.getName().equals(charRel.getName())) continue;
                        charRel.setId(searchChar.getUuid());
                        break;
                    }
                }
                if (charRel.getId() != null) continue;
                charRel.setId(this.getName() + "-" + charRel.getName());
            }
        }
    }

    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceSpecificationCharacteristic findSpecCharacteristicByName(String a) {
        for (ResourceSpecificationCharacteristic ssci : this.getResourceSpecCharacteristic()) {
            if (!ssci.getName().equals(a)) continue;
            return ssci;
        }
        return null;
    }
}

