/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.validation.annotation.Validated;

@Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among Specification Characteristics.")
@Validated
@Entity(name="ResourceSpecCharRelationship")
public class ResourceSpecCharRelationship {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    protected String uuid = null;
    @JsonProperty(value="relationshipType")
    private String reltype = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public ResourceSpecCharRelationship() {
    }

    public ResourceSpecCharRelationship(ResourceSpecCharRelationship src) {
        this.name = src.name;
        this.reltype = src.reltype;
        this.validFor = new TimePeriod(src.validFor);
        this.id = src.id;
    }

    public String getReltype() {
        return this.reltype;
    }

    public void setReltype(String reltype) {
        this.reltype = reltype;
    }

    public ResourceSpecCharRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the target characteristic")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Schema(description="Unique identifier of the target specification")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceSpecCharRelationship href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="Hyperlink reference to the target specification")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ResourceSpecCharRelationship type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="class type of target specification")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceSpecCharRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the object is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecCharRelationship resourceSpecCharRelationship = (ResourceSpecCharRelationship)o;
        return Objects.equals(this.type, resourceSpecCharRelationship.type) && Objects.equals(this.name, resourceSpecCharRelationship.name) && Objects.equals(this.id, resourceSpecCharRelationship.id) && Objects.equals(this.href, resourceSpecCharRelationship.href) && Objects.equals(this.type, resourceSpecCharRelationship.type) && Objects.equals(this.validFor, resourceSpecCharRelationship.validFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSpecCharRelationship {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

