/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.rcm634.model.ResourceGraphSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Describes link between resource graph specifications.")
@Validated
@Entity(name="ResourceGraphSpecRel")
public class ResourceGraphSpecificationRelationship
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="resourceGraph")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ResourceGraphSpecificationRef resourceGraph = null;

    public ResourceGraphSpecificationRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="unique identifier")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ResourceGraphSpecificationRelationship href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public ResourceGraphSpecificationRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Semantic of the relationship.")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ResourceGraphSpecificationRelationship resourceGraph(ResourceGraphSpecificationRef resourceGraph) {
        this.resourceGraph = resourceGraph;
        return this;
    }

    @Schema(description="")
    @Valid
    public ResourceGraphSpecificationRef getResourceGraph() {
        return this.resourceGraph;
    }

    public void setResourceGraph(ResourceGraphSpecificationRef resourceGraph) {
        this.resourceGraph = resourceGraph;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGraphSpecificationRelationship resourceGraphSpecificationRelationship = (ResourceGraphSpecificationRelationship)o;
        return Objects.equals(this.id, resourceGraphSpecificationRelationship.id) && Objects.equals(this.href, resourceGraphSpecificationRelationship.href) && Objects.equals(this.relationshipType, resourceGraphSpecificationRelationship.relationshipType) && Objects.equals(this.resourceGraph, resourceGraphSpecificationRelationship.resourceGraph) && Objects.equals(this.baseType, resourceGraphSpecificationRelationship.baseType) && Objects.equals(this.schemaLocation, resourceGraphSpecificationRelationship.schemaLocation) && Objects.equals(this.type, resourceGraphSpecificationRelationship.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.relationshipType, this.resourceGraph, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceGraphSpecificationRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    resourceGraph: ").append(this.toIndentedString(this.resourceGraph)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

