/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.rcm634.model.ConnectionSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceGraphSpecificationRelationship;
import org.springframework.validation.annotation.Validated;

@Schema(description="Resource graph specification.")
@Validated
@Entity(name="ResourceGraphSpec")
public class ResourceGraphSpecification
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="connectionSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ConnectionSpecification> connectionSpecification = new HashSet<ConnectionSpecification>();
    @JsonProperty(value="graphSpecificationRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceGraphSpecificationRelationship> graphSpecificationRelationship = new HashSet<ResourceGraphSpecificationRelationship>();

    public ResourceGraphSpecification description(String description) {
        this.description = description;
        return this;
    }

    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    @Schema(description="Description of the resource graph specification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceGraphSpecification connectionSpecification(Set<ConnectionSpecification> connectionSpecification) {
        this.connectionSpecification = connectionSpecification;
        return this;
    }

    public ResourceGraphSpecification addConnectionSpecificationItem(ConnectionSpecification connectionSpecificationItem) {
        this.connectionSpecification.add(connectionSpecificationItem);
        return this;
    }

    @Schema(description="Resource graph edge specifications.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) Set<ConnectionSpecification> getConnectionSpecification() {
        return this.connectionSpecification;
    }

    public void setConnectionSpecification(Set<ConnectionSpecification> connectionSpecification) {
        this.connectionSpecification = connectionSpecification;
    }

    public ResourceGraphSpecification graphSpecificationRelationship(Set<ResourceGraphSpecificationRelationship> graphSpecificationRelationship) {
        this.graphSpecificationRelationship = graphSpecificationRelationship;
        return this;
    }

    public ResourceGraphSpecification addGraphSpecificationRelationshipItem(ResourceGraphSpecificationRelationship graphSpecificationRelationshipItem) {
        if (this.graphSpecificationRelationship == null) {
            this.graphSpecificationRelationship = new HashSet<ResourceGraphSpecificationRelationship>();
        }
        this.graphSpecificationRelationship.add(graphSpecificationRelationshipItem);
        return this;
    }

    @Schema(description="Relationships to other resource graph specifications.")
    @Valid
    public Set<ResourceGraphSpecificationRelationship> getGraphSpecificationRelationship() {
        return this.graphSpecificationRelationship;
    }

    public void setGraphSpecificationRelationship(Set<ResourceGraphSpecificationRelationship> graphSpecificationRelationship) {
        this.graphSpecificationRelationship = graphSpecificationRelationship;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGraphSpecification resourceGraphSpecification = (ResourceGraphSpecification)o;
        return Objects.equals(this.uuid, resourceGraphSpecification.uuid) && Objects.equals(this.href, resourceGraphSpecification.href) && Objects.equals(this.description, resourceGraphSpecification.description) && Objects.equals(this.name, resourceGraphSpecification.name) && Objects.equals(this.connectionSpecification, resourceGraphSpecification.connectionSpecification) && Objects.equals(this.graphSpecificationRelationship, resourceGraphSpecification.graphSpecificationRelationship) && Objects.equals(this.baseType, resourceGraphSpecification.baseType) && Objects.equals(this.schemaLocation, resourceGraphSpecification.schemaLocation) && Objects.equals(this.type, resourceGraphSpecification.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.href, this.description, this.name, this.connectionSpecification, this.graphSpecificationRelationship, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceGraphSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    connectionSpecification: ").append(this.toIndentedString(this.connectionSpecification)).append("\n");
        sb.append("    graphSpecificationRelationship: ").append(this.toIndentedString(this.graphSpecificationRelationship)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

