/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.rcm634.model.ConnectionPointSpecificationRef;
import org.etsi.osl.tmf.rcm634.model.LogicalResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceGraphSpecification;
import org.springframework.validation.annotation.Validated;

@Schema(description="Specifies a function as a behavior to transform inputs of any nature into outputs of any nature independently from the way it is provided, for example a Medium to Large Enterprise Firewall.")
@Validated
@Entity(name="Resfuncspec")
public class ResourceFunctionSpecification
extends LogicalResourceSpecification {
    @JsonProperty(value="connectionPointSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ConnectionPointSpecificationRef> connectionPointSpecification = new HashSet<ConnectionPointSpecificationRef>();
    @JsonProperty(value="connectivitySpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceGraphSpecification> connectivitySpecification = new HashSet<ResourceGraphSpecification>();

    public ResourceFunctionSpecification() {
        this.baseType = "LogicalResourceSpecification";
        this.type = "ResourceFunctionSpecification";
    }

    public ResourceFunctionSpecification connectionPointSpecification(Set<ConnectionPointSpecificationRef> connectionPointSpecification) {
        this.connectionPointSpecification = connectionPointSpecification;
        return this;
    }

    public ResourceFunctionSpecification addConnectionPointSpecificationItem(ConnectionPointSpecificationRef connectionPointSpecificationItem) {
        if (this.connectionPointSpecification == null) {
            this.connectionPointSpecification = new HashSet<ConnectionPointSpecificationRef>();
        }
        this.connectionPointSpecification.add(connectionPointSpecificationItem);
        return this;
    }

    @Schema(description="External connection point specifications. These are the service access points (SAP) where inputs and outputs of the function are available.")
    @Valid
    public Set<ConnectionPointSpecificationRef> getConnectionPointSpecification() {
        return this.connectionPointSpecification;
    }

    public void setConnectionPointSpecification(Set<ConnectionPointSpecificationRef> connectionPointSpecification) {
        this.connectionPointSpecification = connectionPointSpecification;
    }

    public ResourceFunctionSpecification connectivitySpecification(Set<ResourceGraphSpecification> connectivitySpecification) {
        this.connectivitySpecification = connectivitySpecification;
        return this;
    }

    public ResourceFunctionSpecification addConnectivitySpecificationItem(ResourceGraphSpecification connectivitySpecificationItem) {
        if (this.connectivitySpecification == null) {
            this.connectivitySpecification = new HashSet<ResourceGraphSpecification>();
        }
        this.connectivitySpecification.add(connectivitySpecificationItem);
        return this;
    }

    @Schema(description="Internal connectivity potential specifications.")
    @Valid
    public Set<ResourceGraphSpecification> getConnectivitySpecification() {
        return this.connectivitySpecification;
    }

    public void setConnectivitySpecification(Set<ResourceGraphSpecification> connectivitySpecification) {
        this.connectivitySpecification = connectivitySpecification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFunctionSpecification resourceFunctionSpecification = (ResourceFunctionSpecification)o;
        return Objects.equals(this.uuid, resourceFunctionSpecification.uuid) && Objects.equals(this.href, resourceFunctionSpecification.href) && Objects.equals(this.category, resourceFunctionSpecification.category) && Objects.equals(this.description, resourceFunctionSpecification.description) && Objects.equals(this.isBundle, resourceFunctionSpecification.isBundle) && Objects.equals(this.lastUpdate, resourceFunctionSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, resourceFunctionSpecification.lifecycleStatus) && Objects.equals(this.name, resourceFunctionSpecification.name) && Objects.equals(this.version, resourceFunctionSpecification.version) && Objects.equals(this.attachment, resourceFunctionSpecification.attachment) && Objects.equals(this.connectionPointSpecification, resourceFunctionSpecification.connectionPointSpecification) && Objects.equals(this.connectivitySpecification, resourceFunctionSpecification.connectivitySpecification) && Objects.equals(this.featureSpecification, resourceFunctionSpecification.featureSpecification) && Objects.equals(this.relatedParty, resourceFunctionSpecification.relatedParty) && Objects.equals(this.resourceSpecCharacteristic, resourceFunctionSpecification.resourceSpecCharacteristic) && Objects.equals(this.resourceSpecRelationship, resourceFunctionSpecification.resourceSpecRelationship) && Objects.equals(this.targetResourceSchema, resourceFunctionSpecification.targetResourceSchema) && Objects.equals(this.validFor, resourceFunctionSpecification.validFor) && Objects.equals(this.baseType, resourceFunctionSpecification.baseType) && Objects.equals(this.schemaLocation, resourceFunctionSpecification.schemaLocation) && Objects.equals(this.type, resourceFunctionSpecification.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.href, this.category, this.description, this.isBundle, this.lastUpdate, this.lifecycleStatus, this.name, this.version, this.attachment, this.connectionPointSpecification, this.connectivitySpecification, this.featureSpecification, this.relatedParty, this.resourceSpecCharacteristic, this.resourceSpecRelationship, this.targetResourceSchema, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceFunctionSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    connectionPointSpecification: ").append(this.toIndentedString(this.connectionPointSpecification)).append("\n");
        sb.append("    connectivitySpecification: ").append(this.toIndentedString(this.connectivitySpecification)).append("\n");
        sb.append("    featureSpecification: ").append(this.toIndentedString(this.featureSpecification)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecCharacteristic: ").append(this.toIndentedString(this.resourceSpecCharacteristic)).append("\n");
        sb.append("    resourceSpecRelationship: ").append(this.toIndentedString(this.resourceSpecRelationship)).append("\n");
        sb.append("    targetResourceSchema: ").append(this.toIndentedString(this.targetResourceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

