/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceCandidateRef;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The (resource) category resource is used to group resource candidates in logical containers. Categories can contain other categories. Skipped properties: id,href,id,href")
@Validated
public class ResourceCategoryUpdate {
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="@type")
    protected String type = null;
    @JsonProperty(value="@schemalLocation")
    protected String schemalLocation = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="parentId")
    protected String parentId = null;
    @JsonProperty(value="isRoot")
    protected Boolean isRoot = null;
    @JsonProperty(value="category")
    @Valid
    protected List<ResourceCategoryRef> category = null;
    @JsonProperty(value="resourceCandidate")
    @Valid
    protected List<ResourceCandidateRef> resourceCandidate = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;

    public ResourceCategoryUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the category")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceCategoryUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the category")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceCategoryUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The (class) type of this category")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceCategoryUpdate schemalLocation(String schemalLocation) {
        this.schemalLocation = schemalLocation;
        return this;
    }

    @Schema(description="This field provides a link to the schema describing this REST resource")
    public String getSchemalLocation() {
        return this.schemalLocation;
    }

    public void setSchemalLocation(String schemalLocation) {
        this.schemalLocation = schemalLocation;
    }

    public ResourceCategoryUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="Immediate base class type of this category")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceCategoryUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Category version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ResourceCategoryUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the category is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceCategoryUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ResourceCategoryUpdate parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Unique identifier of the parent category")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public ResourceCategoryUpdate isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Schema(description="If true, this Boolean indicates that the category is a root of categories")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    public ResourceCategoryUpdate category(List<ResourceCategoryRef> category) {
        this.category = category;
        return this;
    }

    public ResourceCategoryUpdate addCategoryItem(ResourceCategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<ResourceCategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceCategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<ResourceCategoryRef> category) {
        this.category = category;
    }

    public ResourceCategoryUpdate resourceCandidate(List<ResourceCandidateRef> resourceCandidate) {
        this.resourceCandidate = resourceCandidate;
        return this;
    }

    public ResourceCategoryUpdate addResourceCandidateItem(ResourceCandidateRef resourceCandidateItem) {
        if (this.resourceCandidate == null) {
            this.resourceCandidate = new ArrayList<ResourceCandidateRef>();
        }
        this.resourceCandidate.add(resourceCandidateItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ResourceCandidateRef> getResourceCandidate() {
        return this.resourceCandidate;
    }

    public void setResourceCandidate(List<ResourceCandidateRef> resourceCandidate) {
        this.resourceCandidate = resourceCandidate;
    }

    public ResourceCategoryUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceCategoryUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCategoryUpdate resourceCategoryUpdate = (ResourceCategoryUpdate)o;
        return Objects.equals(this.name, resourceCategoryUpdate.name) && Objects.equals(this.description, resourceCategoryUpdate.description) && Objects.equals(this.type, resourceCategoryUpdate.type) && Objects.equals(this.schemalLocation, resourceCategoryUpdate.schemalLocation) && Objects.equals(this.baseType, resourceCategoryUpdate.baseType) && Objects.equals(this.version, resourceCategoryUpdate.version) && Objects.equals(this.validFor, resourceCategoryUpdate.validFor) && Objects.equals(this.lifecycleStatus, resourceCategoryUpdate.lifecycleStatus) && Objects.equals(this.parentId, resourceCategoryUpdate.parentId) && Objects.equals(this.isRoot, resourceCategoryUpdate.isRoot) && Objects.equals(this.category, resourceCategoryUpdate.category) && Objects.equals(this.resourceCandidate, resourceCategoryUpdate.resourceCandidate) && Objects.equals(this.relatedParty, resourceCategoryUpdate.relatedParty);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCategoryUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemalLocation: ").append(this.toIndentedString(this.schemalLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    resourceCandidate: ").append(this.toIndentedString(this.resourceCandidate)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

