/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Category reference. The category resource is used to group product offerings, service and resource candidates in logical containers. Categories can contain other categories and/or product offerings, resource or service candidates.")
@Validated
public class ResourceCategoryRef
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="version")
    private String version = null;

    public ResourceCategoryRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique reference of the category")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ResourceCategoryRef version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Category version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCategoryRef categoryRef = (ResourceCategoryRef)o;
        return Objects.equals(this.id, categoryRef.id) && Objects.equals(this.href, categoryRef.href) && Objects.equals(this.version, categoryRef.version) && Objects.equals(this.name, categoryRef.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

