/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="The (resource) category resource is used to group resource candidates in logical containers. Categories can contain other categories. Skipped properties: id,href")
@Validated
public class ResourceCategoryCreate
extends ResourceCategoryUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    @Override
    public ResourceCategoryCreate name(String name) {
        this.name = name;
        return this;
    }

    public ResourceCategoryCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCategoryCreate resourceCategoryCreate = (ResourceCategoryCreate)o;
        return Objects.equals(this.name, resourceCategoryCreate.name) && Objects.equals(this.description, resourceCategoryCreate.description) && Objects.equals(this.type, resourceCategoryCreate.type) && Objects.equals(this.schemalLocation, resourceCategoryCreate.schemalLocation) && Objects.equals(this.baseType, resourceCategoryCreate.baseType) && Objects.equals(this.version, resourceCategoryCreate.version) && Objects.equals(this.validFor, resourceCategoryCreate.validFor) && Objects.equals(this.lifecycleStatus, resourceCategoryCreate.lifecycleStatus) && Objects.equals(this.lastUpdate, resourceCategoryCreate.lastUpdate) && Objects.equals(this.parentId, resourceCategoryCreate.parentId) && Objects.equals(this.isRoot, resourceCategoryCreate.isRoot) && Objects.equals(this.category, resourceCategoryCreate.category) && Objects.equals(this.resourceCandidate, resourceCategoryCreate.resourceCandidate) && Objects.equals(this.relatedParty, resourceCategoryCreate.relatedParty);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.schemalLocation, this.baseType, this.version, this.validFor, this.lifecycleStatus, this.lastUpdate, this.parentId, this.isRoot, this.category, this.resourceCandidate, this.relatedParty);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCategoryCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemalLocation: ").append(this.toIndentedString(this.schemalLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    resourceCandidate: ").append(this.toIndentedString(this.resourceCandidate)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

