/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.rcm634.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.rcm634.model.ResourceCandidate;
import org.etsi.osl.tmf.rcm634.model.ResourceCandidateRef;
import org.etsi.osl.tmf.rcm634.model.ResourceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The (resource) category resource is used to group resource candidates in logical containers. Categories can contain other categories.")
@Validated
@Entity(name="ResourceCategory")
public class ResourceCategory
extends BaseEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="parentId")
    private String parentId = null;
    @JsonProperty(value="isRoot")
    private Boolean isRoot = null;
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<ResourceCategory> categoryObj = new HashSet<ResourceCategory>();
    @ManyToMany(cascade={CascadeType.MERGE, CascadeType.REMOVE})
    @JoinTable
    @JsonIgnore
    private Set<ResourceCandidate> resourceCandidateObj = new HashSet<ResourceCandidate>();

    @Schema(description="Unique identifier of the category")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ResourceCategory parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Unique identifier of the parent category")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public ResourceCategory isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Schema(description="If true, this Boolean indicates that the category is a root of categories")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    @Schema(description="List of child categories in the tree for in this category")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<ResourceCategoryRef> getCategoryRefs() {
        ArrayList<ResourceCategoryRef> category = new ArrayList<ResourceCategoryRef>();
        for (ResourceCategory resourceCategory : this.categoryObj) {
            ResourceCategoryRef scr = new ResourceCategoryRef();
            scr.setId(resourceCategory.getId());
            scr.setName(resourceCategory.getName());
            scr.setBaseType(ResourceCategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    @JsonProperty(value="category")
    public void setCategoryObj(List<ResourceCategoryRef> alist) {
        this.categoryObj.clear();
        for (ResourceCategoryRef resCategoryRef : alist) {
            ResourceCategory sc = new ResourceCategory();
            sc.setUuid(resCategoryRef.getId());
            sc.setName(resCategoryRef.getName());
            sc.setBaseType(resCategoryRef.getBaseType());
            this.categoryObj.add(sc);
        }
    }

    public Set<ResourceCategory> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<ResourceCategory> categoryObj) {
        this.categoryObj = categoryObj;
    }

    @Schema(description="List of resource candidates associated with this category")
    @Valid
    @JsonProperty(value="resourceCandidate")
    public List<ResourceCandidateRef> getResourceCandidateRefs() {
        ArrayList<ResourceCandidateRef> scref = new ArrayList<ResourceCandidateRef>();
        for (ResourceCandidate sc : this.resourceCandidateObj) {
            ResourceCandidateRef scr = new ResourceCandidateRef();
            scr.setId(sc.getId());
            scr.setName(sc.getName());
            scr.setVersion(sc.getVersion());
            scr.setBaseType(ResourceCategoryRef.class.getName());
            scref.add(scr);
        }
        return scref;
    }

    public Set<ResourceCandidate> getResourceCandidateObj() {
        return this.resourceCandidateObj;
    }

    public void setResourceCandidateObj(Set<ResourceCandidate> resourceCandidateObj) {
        this.resourceCandidateObj = resourceCandidateObj;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCategory resourceCategory = (ResourceCategory)o;
        return Objects.equals(this.id, resourceCategory.id) && Objects.equals(this.href, resourceCategory.href) && Objects.equals(this.name, resourceCategory.name) && Objects.equals(this.description, resourceCategory.description) && Objects.equals(this.type, resourceCategory.type) && Objects.equals(this.baseType, resourceCategory.baseType) && Objects.equals(this.version, resourceCategory.version) && Objects.equals(this.validFor, resourceCategory.validFor) && Objects.equals(this.lifecycleStatus, resourceCategory.lifecycleStatus) && Objects.equals(this.lastUpdate, resourceCategory.lastUpdate) && Objects.equals(this.parentId, resourceCategory.parentId) && Objects.equals(this.isRoot, resourceCategory.isRoot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceCategory {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategoryRefs())).append("\n");
        sb.append("    resourceCandidate: ").append(this.toIndentedString(this.getResourceCandidateRefs())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

